<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PolicyController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'App\Http\Controllers\RouterController@index');
Route::get('/index', 'App\Http\Controllers\RouterController@index');

Route::get('/about', 'App\Http\Controllers\RouterController@about');
Route::get('/History', 'App\Http\Controllers\RouterController@history');
Route::get('/OilandGas', 'App\Http\Controllers\RouterController@oilandgas');
Route::get('/investor', 'App\Http\Controllers\RouterController@investor');
Route::get('/subsidiaries', 'App\Http\Controllers\RouterController@subsidiaries');
Route::get('/Aviation', 'App\Http\Controllers\RouterController@aviation');
Route::get('/marine', 'App\Http\Controllers\RouterController@marine');
Route::get('/Groupaccident','App\Http\Controllers\RouterController@grourepaccident');
Route::get('/contact', 'App\Http\Controllers\RouterController@contact');
Route::get('/Engineering', 'App\Http\Controllers\RouterController@engineeringindex');
Route::get('/Engineering/{plan}', 'App\Http\Controllers\RouterController@engineering');

Route::get('/business', 'App\Http\Controllers\RouterController@businessindex');
Route::get('/business/{plan}', 'App\Http\Controllers\RouterController@business');

Route::get('/fire', 'App\Http\Controllers\RouterController@fire');
Route::get('/fire/{plan}', 'App\Http\Controllers\RouterController@fire');

Route::get('/fire_sIndex', 'App\Http\Controllers\RouterController@fire_sIndex');
//Route::get('/fire/{plan}', 'App\Http\Controllers\RouterController@fire');

//travel routes
Route::get('/travel', 'App\Http\Controllers\PolicyController@travelPolicy');
Route::get('/policy/country/{id}', 'App\Http\Controllers\PolicyController@getPolicyCountries');
Route::post('/policy/plans/{id}', 'App\Http\Controllers\PolicyController@getSubPolicyPlans');
Route::post('/policy/addPolicyIntoDB', 'App\Http\Controllers\PolicyController@ajaxAddPersonalPolicyIntoDB');
Route::post('/proceedToCheckout/{id}', 'App\Http\Controllers\PolicyController@ajaxProceedToCheckout');

Route::get('/Agric', 'App\Http\Controllers\RouterController@agricindex');
Route::get('/Agric/{plan}', 'App\Http\Controllers\RouterController@agric');

Route::get('/profile/{whom}', 'App\Http\Controllers\RouterController@profile');

Route::get('/motor', 'App\Http\Controllers\RouterController@motor');
Route::get('/motor/{plan}', 'App\Http\Controllers\RouterController@motor');

Route::get('/personal', 'App\Http\Controllers\RouterController@personal');
Route::get('/personal/{plan}', 'App\Http\Controllers\RouterController@personal');

Route::get('/house', 'App\Http\Controllers\RouterController@house');
Route::get('/house/{plan}', 'App\Http\Controllers\RouterController@house');

Route::get('/personal', 'App\Http\Controllers\PolicyController@personalPolicy');
Route::post('/confirmCheckout', 'App\Http\Controllers\PolicyController@confirmCheckout');
Route::get('/house', 'App\Http\Controllers\PolicyController@householderPolicy');
//Route::get('/certificate', 'App\Http\Controllers\PolicyController::generateCertificate()');
Route::get('/fire', 'App\Http\Controllers\PolicyController@firePolicy');
Route::get('/marine', 'App\Http\Controllers\PolicyController@marinePolicy');
Route::post('addMarinePolicyIntoDB', 'App\Http\Controllers\PolicyController@addMarinePolicyIntoDB')->name('addMarinePolicyIntoDB');
Route::get('/motor', 'App\Http\Controllers\PolicyController@motorPolicy');
Route::get('bookPolicy/{id}', 'App\Http\Controllers\PolicyController@bookPolicy');
Route::get('bookPolicy/ajax/{id}', 'App\Http\Controllers\PolicyController@getVehicleModel');
Route::get('bookPackage/{id}', 'App\Http\Controllers\PolicyController@bookPackage');
Route::get('/getVehicleModels/{makeCode}', 'App\Http\Controllers\PolicyController@getVehicleModels')->name('get-model-records'); //get vehicle models for a make
Route::get('checkout', 'App\Http\Controllers\PolicyController@checkoutPage')->name('checkoutPage');
Route::get('/fire_sIndex', 'App\Http\Controllers\PolicyController@fire_sPolicy');
Route::get('/retail_index', 'App\Http\Controllers\RouterController@retail_landing');
Route::get('/login', 'App\Http\Controllers\PolicyController@account_login')->name('login');
Route::get('/newsletter', 'App\Http\Controllers\PolicyController@newsletter');
Route::get('/logout', 'App\Http\Controllers\PolicyController@account_logout');
Route::get('/changePassword', 'App\Http\Controllers\PolicyController@changePassword');
Route::get('/register', 'App\Http\Controllers\RouterController@account_register');
Route::post('addPersonalPolicyIntoDB', 'App\Http\Controllers\PolicyController@addPersonalPolicyIntoDB')->name('addPersonalPolicyIntoDB');
Route::get('addPersonalPolicyIntoDBPage', 'App\Http\Controllers\PolicyController@addPersonalPolicyIntoDBPage')->name('addPersonalPolicyIntoDBPage');
Route::post('accountVerify', 'App\Http\Controllers\PolicyController@accountVerify');
Route::post('newsletterUpdate', 'App\Http\Controllers\PolicyController@newsletterUpdate');
Route::post('updateChangePassword', 'App\Http\Controllers\PolicyController@updateChangePassword');
Route::post('personaldetailsUpload', 'App\Http\Controllers\PolicyController@personaldetailsUpload');
Route::post('submitRegister', 'App\Http\Controllers\PolicyController@submitRegistrationForm');
Route::post('submitLogin', 'App\Http\Controllers\PolicyController@submitLoginForm');
Route::post('checkoutLogin', 'App\Http\Controllers\PolicyController@checkoutLogin');
Route::get('/customerdash', 'App\Http\Controllers\PolicyController@customerDashboard');
Route::get('/editaccount', 'App\Http\Controllers\PolicyController@editaccount');
Route::get('/orders', 'App\Http\Controllers\PolicyController@orders');
Route::get('/transactions', 'App\Http\Controllers\PolicyController@transactions')->name('transactions');;
Route::post('/transactions', 'App\Http\Controllers\PolicyController@transactionsFilter')->name('transaction-filter');
Route::get('/commissions', 'App\Http\Controllers\PolicyController@commissionPayment')->name('commPayment');
Route::post('/commissionUpdate', 'App\Http\Controllers\PolicyController@UpdateCommission')->name('commissionUpdate');
Route::get('order_detail/{id}', 'App\Http\Controllers\PolicyController@order_detail');
Route::post('/pay', 'App\Http\Controllers\PolicyController@redirectToGateway')->name('pay'); //paystack payment route
Route::get('/payment/callback', 'App\Http\Controllers\PolicyController@handleGatewayCallback'); //paystack callback route
Route::get('/certificate/{id}', 'App\Http\Controllers\PolicyController@generateCertificate');
Route::get('/naicomPush/{id}', 'App\Http\Controllers\PolicyController@repushNaicom');
Route::get('/bulkGombenaicomPush', 'App\Http\Controllers\PolicyController@repushGombeNaicom'); //push Gombe to NAICOM
Route::get('/niidUpload', 'App\Http\Controllers\SoapController@getNiidData')->name('niid-upload');
Route::get('/whatsappNiidUpload', 'App\Http\Controllers\SoapController@getWhatsappNiidData')->name('whatsapp-niid-upload');
Route::get('/niidCustomerUpload/{id}', 'App\Http\Controllers\SoapController@uploadCustomerToNiid')->name('customer-niid-upload'); // upload single policy to niid
Route::get('/niidBulkUpload/{date_from}/{date_to}', 'App\Http\Controllers\SoapController@bulkUploadCustomerToNiid')->name('niid-bulk-upload'); // bulk upload multiple policy to niid using date range

Route::get('/renewals', 'App\Http\Controllers\RenewalController@renewal');
Route::get('/repayment', 'App\Http\Controllers\PolicyController@repaymentFunc'); // repayment for when transactions failed
Route::get('/payments/repaymentcallback', 'App\Http\Controllers\PolicyController@repaymentCallback'); //call back url for repayment.
Route::post('/verifyRenewal', 'App\Http\Controllers\RenewalController@verifyRenewal');
Route::get('/confirmRenewal', 'App\Http\Controllers\RenewalController@confirmRenewal');
Route::get('/policyExpiry', 'App\Http\Controllers\PolicyExpiryController@getExpiredPolicy'); //sends expiration email(implemented) and SMS to customers
Route::get('/renewExpired/{id}', 'App\Http\Controllers\PolicyExpiryController@renewExpiredPolicy'); //from expration email to checkout page
Route::get('/updateWhatsappCustomer', 'App\Http\Controllers\PolicyExpiryController@UpdateNumberWhatsapp'); //Update Whatsapp Phone Numbers from Id Number to Phone Number on retail DB
Route::get('/testsms', 'App\Http\Controllers\SmsController@sendTestSms'); //sends expiration email(implemented) and SMS to customers


//reprint certificate
Route::get('/reprintcert', 'App\Http\Controllers\PolicyController@reprintcert');
Route::post('/verifyReprint', 'App\Http\Controllers\PolicyController@verifyReprint');

// Forgot Password
Route::get('/forgotPassword', 'App\Http\Controllers\PolicyController@forgotPasswordPage')->name('forgot-password-form');
Route::post('/passwordRecoveryMail', 'App\Http\Controllers\PolicyController@passwordRecoveryMail')->name('Get-Password-Recovery-Email');
Route::get('/resetPassword/{id}', 'App\Http\Controllers\PolicyController@resetPasswordPage')->name('reset-password-form');
Route::post('/resetPassword', 'App\Http\Controllers\PolicyController@resetPassword')->name('reset-password');

//Route::get('certificate', [PolicyController::class, 'Certificate']);

//whatsapp routes
Route::get('/paywhatsapp/{id}', 'App\Http\Controllers\WhatsappSalesController@getWhatsappDetails')->name('paywhatsapp'); //sales for whatsapp
Route::get('/payment/whatsappCallback/{reference_id}', 'App\Http\Controllers\WhatsappSalesController@verifyWhatsappPayment'); //verify Whatsapp Payments
Route::get('/certificatew/{id}', 'App\Http\Controllers\WhatsappSalesController@generateCertificate'); //Generate Whatsapp Certificate

//Agency Routes
Route::post('/agencyPayment', 'App\Http\Controllers\AgencyController@handleAgencyPayment')->name('agencyPayment');
Route::get('/unremittedAgent', 'App\Http\Controllers\AgencyController@agencyUnremitted')->name('unremitted-agency');
Route::get('/unremittedAdmin', 'App\Http\Controllers\AgencyController@adminAgencyUnremitted')->name('unremitted-agency-admin'); 
Route::post('/verify_transaction/{reference_id}/vendor/{vendor_id}', 'App\Http\Controllers\AgencyController@verifyPayment')->name('verify-payment');
Route::get('/agencytransactions', 'App\Http\Controllers\AgencyController@agencytransaction')->name('agency-transaction');
Route::get('/transactionSchedule/{id}', 'App\Http\Controllers\AgencyController@generateSchedule')->name('generate-schedule');
Route::get('/listTeamMembers', 'App\Http\Controllers\AgencyController@listAgencyMembers')->name('list-team-members');
Route::post('/addNewMember', 'App\Http\Controllers\AgencyController@addNewMember')->name('add-New-Member');
Route::post('/updatetransactionToken', 'App\Http\Controllers\AgencyController@updateTransactionToken')->name('update-transaction-token');
Route::get('/teamtransactions', 'App\Http\Controllers\AgencyController@teamtransactions')->name('team-transactions');
Route::post('/teamstransactions', 'App\Http\Controllers\AgencyController@teamtransactionsFilter')->name('team-transaction-filter');
Route::post('/directwalletPayment', 'App\Http\Controllers\WalletController@handleDirectWalletPayment')->name('direct-wallet-payment');
Route::post('/walletPayment', 'App\Http\Controllers\AgencyController@updateAgentWalletPayment')->name('wallet-payment');
Route::get('/manageWallet', 'App\Http\Controllers\WalletController@manageWallet')->name('mng-wallet');
Route::post('/verify_wallet_transaction/{reference_id}/customer/{vendor_id}', 'App\Http\Controllers\WalletController@verifyPayment')->name('verify-wallet-payment');

//direct debits and autorenewal
Route::post('/autorenewalsetup', [RenewalController::class, 'autorenewalsetup'])->name('auto-renewal-setup');
Route::post('/dd/deactivateDD', [RenewalController::class, 'deactivateDD'])->name('deactivate-renewal-setup');
Route::get('/auto/renewal/response', [RenewalController::class, 'autorenewalrsetupesponse'])->name('auto-renewal-response');
Route::get('/dd/authverification', [RenewalController::class, 'authVerification'])->name('dd-auth-verification');
//get DD renewal list
Route::get('/dd/getDDList', [RenewalController::class, 'getDirectDebitRecords'])->name('dd-get-list');

//API Controller
Route::get('/payInsurance/{id}', 'App\Http\Controllers\ApiPaymentController@makeApiPayment');
Route::get('/apiSuccess', 'App\Http\Controllers\ApiMotorComprehensiveController@apiSuccess')->name('apiSuccess');
Route::get('/payment/apiCallBack/{reference_id}', 'App\Http\Controllers\ApiPaymentController@verifyApiPayment'); //verify Comprehensive Api Payments
Route::get('/certificateapi/{id}', 'App\Http\Controllers\ApiPaymentController@generateCertificate');
Route::get('/certificate_rifan/{id}', 'App\Http\Controllers\ApiRifanIntegration@generateCertificate');


//Utils
Route::post('/mail/businessinteruption','App\Http\Controllers\UtilController@business');

Route::get('/send-mail', 'App\Http\Controllers\MailController@sendTestMail');



