@extends('template')
<title>Veritas Kapital Assurance PLC - Travel Insurance</title>
@section('content')
@include('layouts.header')

<main id="main">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
    <!-- ======= Breadcrumbs Section ======= -->
    <section class="breadcrumbs">
        <div class="container">

            <div class="d-flex justify-content-between align-items-center">
                <ol>
                    <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
                    <li>Travel Insurance</li>
                </ol>
            </div>

        </div>
    </section><!-- End Breadcrumbs Section -->
    
    @if($errors->any())
        <div class="alert alert-danger text-center"><h4>{{$errors->first()}}</h4></div>
    @endif

    <!-- ======= Pricing Section ======= -->
    <section id="pricing" class="pricing inner-page">
        <div class="container" data-aos="fade-up">

            <div class="category-title">
                <h1>Travel Insurance</h1>
                <p>Embark on your journey with peace of mind! Whether you're traveling for business, leisure, or with your family, our Travel Insurance Plan ensures you're covered every step of the way. Enjoy every moment of your trip knowing you're protected against unexpected events, so you can focus on making memories, not worries</p>
            </div>

            <div class="row">
                @if ( (Session::has('teamId') && $accessStatus === 1) || (Session::has('user_id') && $accessStatus === 0) )
                    @foreach ($fPolicy as $policyData)
                    <div class="col-lg-4 pro-sec" data-aos="fade-up" data-aos-delay="100">
                        <div class="box">
                            <div class="ins-det">
                                <img src="{{ asset('assets/img/icons/aviation.png') }}"><br />
                                <h4><a href="javascript:void(0)" style="font-size:20px;"> {{ $policyData->subPolicy_name }} </a></h4>
                            </div>
                            <a href="javascript:void(0)" class="vk-btn light travelModalTrigger" rel="{{ $policyData->subPolicy_id }}" relName="{{ $policyData->subPolicy_name }}">Buy Policy</a>
                        </div>
                    </div>
                    @endforeach
                @elseif (Session::has('teamId') && $accessStatus === 0)
                        <div class=" col-md-8 offset-2 alert alert-danger text-center" role="alert">
                            <i class="fa fa-window-close"></i> You do not have permission to purchase this policy!
                        </div>
                @else
                    <div class="tab-menu col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <ul class="nav nav-tabs" id="myTabs">
                            @foreach($grouping as $policyData)
                                <li class="nav-item">
                                    <a class="nav-link btn btn-success @if($loop->first) active @endif" data-toggle="tab" href="#tab{{ $loop->iteration }}">{{ $policyData->name }}</a>
                                </li>
                            @endforeach
                        </ul>
                    </div>


                
                    <!-- Content area -->
                    <div class="tab-content col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
    @foreach($grouping as $policyData)
        <div id="tab{{ $loop->iteration }}" class="tab-pane fade @if($loop->first) show active @endif">
            <h1 class="mt-4" style="color: #303164; font-family: 'Arial', sans-serif; text-align: center; text-transform: uppercase; font-weight: bold;">
                {{ $policyData->name }}
            </h1>
            <div class="row p-1">
                @foreach($policyData->list as $plansData)
                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-xs-12 pro-se pt-0" data-aos="fade-up" data-aos-delay="100">
                        <div class="text-center m-2 p-2" 
                             style="border: 2px solid #62d536; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.2); transition: all 0.3s ease-in-out; background: linear-gradient(45deg, #303164, #62d536); animation: backgroundAnimation 5s infinite;">
                            <div class="ins-det" style="padding: 20px; background-color: white; border-radius: 10px;">
                                <div class="row">
                                    <div class="col-12 d-flex justify-content-center align-items-center">
                                        <img src="{{ asset('assets/img/icons/aviation.png') }}" 
                                             alt="Policy Icon" 
                                             style="width: 80px; height: auto; transition: transform 0.3s;" 
                                             onmouseover="this.style.transform='scale(1.1)'" 
                                             onmouseout="this.style.transform='scale(1)'"/>
                                    </div>
                                </div>
                                <h4 style="color: #303164; font-size: 20px; font-weight: bold; margin-top: 10px;">
                                    <a href="javascript:void(0)" 
                                       class="travelModalTrigger" 
                                       style="text-decoration: none; color: #303164;" 
                                       rel="{{ $plansData->subPolicy_id }}" 
                                       relName="{{ $plansData->subPolicy_name }}">
                                        {{ $plansData->subPolicy_name }}
                                    </a>
                                </h4>
                                <h6 style="color: #555555; font-size: 16px; margin: 10px 0;">
                                    {{ $plansData->subPolicy_description }}
                                </h6>
                                <a href="javascript:void(0)" 
                                   class="travelBenefitTrigger m-2 text-info text-bold" 
                                   style="font-size: 15px; color: #62d536; font-weight: bold;" 
                                   benefit="{{ asset('assets/img/travel/'.$plansData->subPolicy_html.'') }}" 
                                   relName="{{ $plansData->subPolicy_name }}">
                                   View Benefits
                                </a>
                                <br/>
                                <a href="javascript:void(0)" 
                                   class="btn btn-sm travelModalTrigger mt-1" 
                                   rel="{{ $plansData->subPolicy_id }}" 
                                   relName="{{ $plansData->subPolicy_name }}" 
                                   style="background-color: #62d536; color: white; padding: 8px 20px; border-radius: 20px; font-weight: bold; text-transform: uppercase; transition: all 0.3s ease;">
                                   Buy Policy
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    @endforeach
</div>

<style>
    @keyframes backgroundAnimation {
        0% { background-color: #303164; }
        50% { background-color: #62d536; }
        100% { background-color: #303164; }
    }

    @media (max-width: 768px) {
        h1 {
            font-size: 18px;
        }
        h4 {
            font-size: 16px;
        }
        .btn {
            padding: 6px 15px;
            font-size: 14px;
        }
    }
</style>

                @endif
            </div>
        </div>
    </section><!-- End Pricing Section -->

    <div style=" display:none" id="policy" class="text-center">
        <div class="container">
            <h1 style="font-size:1.7em !important; margin:5px 5px 35px 5px;" class="text-center" id="modalTitle"></h1>
           
            <!--<div class="row">
                <div class="col-lg-12 text-center">
                    <p class="text-center"><img src="{{ asset('assets/img/ban1.jpg') }}" class="img-responsive" style="width:auto; max-height:300px; margin:auto !important;" /></p>
                </div>
            </div>-->
            <h1 class="text-bold text-danger"><b>We're currently unable to process travel insurance purchases. Please check back later. We apologize for the inconvenience.</b></h1>
            <!--<p class="text-center text-danger">NOTE: All fields with <small class="text-danger">(*)</small> are compulsory</p>-->
            <div class="row">
                <!--<div class="col-lg-12 text-left">
                    <form action="javascript:void(0)" class="frmTravelModal" id="frmTravelModal" method="post" data-aos="fade-up">
                        @csrf
                        @if (Session::has('user_id'))
                        <input type="hidden" name="customerID" value="{{Session::get('user_id')}}">
                        @else
                        <input type="hidden" name="customerID" value="{{Session::get('user_id')}}">
                        @endif

                        <div class="form-row">
                            <div class="form-group col-sm-6">
                                <label><small class="text-danger">*</small> First Name <span style="font-size:0.7em !important">(as stated in your passport)</span> </label>
                                <input type="text" name="firstName" placeholder="First Name*" id="input-formfields1" class="form-control" required>
                            </div>
                            <div class="form-group col-sm-6">
                                <label><small class="text-danger">*</small> Surname <span style="font-size:0.7em !important">(as stated in your passport)</span></label>
                                <input type="text" name="lastName" placeholder="Surname*" id="input-formfields2" class="form-control" required>
                            </div>
                        </div>
                        <div class="form-row mt-4">
                            <div class="col-sm-6 form-group">
                                <label><small class="text-danger">*</small> Date of Birth <span style="font-size:0.7em !important">(as stated in your passport)</span></label>
                                <input type="date" name="dob" max="{{ $dob_min_date }}" class="form-control datepicker" placeholder="Date of birth*" data-date-format="YYYY-MM-DD" id="input-option3">
                            </div>
                            <div class="col-sm-6 form-group">
                                <label><small class="text-danger">*</small> Gender </label>
                                <select name="gender" class="form-control">
                                    <option value="-1">Select Gender</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-row mt-4">
                            <div class="col-sm-4 form-group">
                                <label><small class="text-danger">*</small> Email Address </label>
                                <input type="email" name="email" placeholder="Email" id="input-formfields4" class="form-control" required>
                            </div>
                            <div class="col-sm-4 form-group">
                                <label><small class="text-danger">*</small> Phone Number <small>(80-xxxx-xxxx)</small></label>
                                <input type="text" id="phone" name="phone" placeholder="Phone number" class="form-control  phone_number" required>
                                <input type="hidden" id="customer_phone_number" name="customer_phone_number" placeholder="Phone number">
                            </div>
                            <div class="col-sm-4 form-group">
                                <label><small class="text-danger">*</small> State of Residence </label>
                                <select name="state" class="form-control">
                                    <option value="-1">State of Residence</option>
                                    <option value="Abuja">Abuja</option>
                                    <option value="Abia">Abia</option>
                                    <option value="Delta">Delta</option>
                                    <option value="Ebonyi">Ebonyi</option>
                                    <option value="Edo">Edo</option>
                                    <option value="Ekiti">Ekiti</option>
                                    <option value="Enugu">Enugu</option>
                                    <option value="Gombe">Gombe</option>
                                    <option value="Imo">Imo</option>
                                    <option value="Jigawa">Jigawa</option>
                                    <option value="Kaduna">Kaduna</option>
                                    <option value="Kano">Kano</option>
                                    <option value="Adamawa">Adamawa</option>
                                    <option value="Katsina">Katsina</option>
                                    <option value="Kebbi">Kebbi</option>
                                    <option value="Kogi">Kogi</option>
                                    <option value="Kwara">Kwara</option>
                                    <option value="Lagos">Lagos</option>
                                    <option value="Nasarawa">Nasarawa</option>
                                    <option value="Niger">Niger</option>
                                    <option value="Ogun">Ogun</option>
                                    <option value="Ondo">Ondo</option>
                                    <option value="Osun">Osun</option>
                                    <option value="Akwa Ibom">Akwa Ibom</option>
                                    <option value="Oyo">Oyo</option>
                                    <option value="Plateau">Plateau</option>
                                    <option value="Rivers">Rivers</option>
                                    <option value="Sokoto">Sokoto</option>
                                    <option value="Taraba">Taraba</option>
                                    <option value="Yobe">Yobe</option>
                                    <option value="Zamfara">Zamfara</option>
                                    <option value="Anambra">Anambra</option>
                                    <option value="Bauchi">Bauchi</option>
                                    <option value="Bayelsa">Bayelsa</option>
                                    <option value="Benue">Benue</option>
                                    <option value="Borno">Borno</option>
                                    <option value="Cross River">Cross River</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-row mt-4">
                            <div class="form-group col-sm-12">
                                <label><small class="text-danger">*</small> Home Address </label>
                                <input type="text" name="address" placeholder="Home Address*" id="input-formfields7" class="form-control" required />
                            </div>
                        </div>
                        <div class="form-row mt-4">
                            <div class="form-group col-sm-6">
                                <label><small class="text-danger">*</small> Passport Number </label>
                                <input type="hidden" name="form_of_id" value="Intl Passport">
                                <input type="text" name="id_number" value="" placeholder="Passport Number" id="input-formfields10" class="form-control">
                            </div>
                            <div class="form-group col-sm-6">
                                <label><small class="text-danger">*</small> Select Destination Country </label>
                                <select name="cmbCountry" class="form-control" id="cmbCountry">
                                </select>
                            </div>
                        </div>
                        <div class="form-row mt-4 mb-5">
                            <div class="form-group col-sm-6">
                                <label><small class="text-danger">*</small> Departure Date </label>
                                <input type="date" name="departure_date" min="{{ $max_date }}" placeholder="Select Departure Date" id="input-formfields10" class="form-control travel_date">
                            </div>
                            <div class="form-group col-sm-6">
                                <label><small class="text-danger">*</small> Expected Return Date </label>
                                <input type="date" name="return_date" min="{{ $max_date }}" placeholder="Select Return Date" id="input-formfields10" class="form-control travel_date">
                            </div>
                        </div>
                        <input type="hidden" name="refer_code" value="" placeholder="Enter Referral Code" id="input-formfields10" class="form-control">
                        <div class="form-row mt-5 mb-5" id="dispPremiumDiv" style="display:none;">

                        </div>
                        <div class="form-row buttons">
                            <div class="form-group col-sm-12">
                                
                                <p class="text-bold text-danger"><b>By Submitting this form, I declare that I have read the <a href="https://veritaskapital.com/privacy.html" class="text-info" target="_blank">privacy information</a> on the use of personal data and confirm that the information above is correct to the best of my knowledge</b></p>
                                <input type="hidden" id="sub_policy_id" name="subPolicyID">
                                <input type="hidden" id="upc" name="upc">
                                <input type="hidden" id="plan_id" name="planID">
                                <input value="Proceed" id="btntravelModalProceed" rel="" type=" button" class="text-center vk-btn blue" style="width:100%;" />
                                <input value="Make Payment" id="btntravelModalProceedToPayment" rel="" type=" button" class="text-center vk-btn blue" style="width:100%; display:none;" />
                            </div>
                        </div>
                    </form>
                </div>-->
                <!--<div class="col-lg-4">
                    <img src="{{ asset('assets/img/side3.jpg') }}" class="img-responsive" />
                </div>-->
            </div>
        </div>
    </div>
    

    <div class="modal fade" id="travelModal" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><img src="{{ asset('assets/img/icons/close-icon.png') }}"></span>
                </button>
                <div class="modal-body" id="travelModalBody">

                </div>
            </div>
        </div>
    </div>
</main><!-- End #main -->
@include('layouts.footer')
@endsection