@extends('template')
<title>Veritas Kapital Assurance PLC - Personal Accident Insurance</title>
@section('content')
@include('layouts.header')

<main id="main">
    <!-- ======= Breadcrumbs Section ======= -->
    <section class="breadcrumbs">
      <div class="container">

        <div class="d-flex justify-content-between align-items-center">
          <h3>Renew an Existing Policy</h3>
        </div>

      </div>
    </section><!-- End Breadcrumbs Section -->

    <!-- ======= Pricing Section ======= -->
    <section id="pricing" class="pricing inner-page">
      <div class="container" data-aos="fade-up">
        <div class="row">
            <div class="col-md-6 col-md-offset-3 col-sm-12 col-xs-12">
                @if (Session::has('verifyError'))
                    <div class="alert alert-danger text-center" role="alert">
                        {{Session::get('verifyError')}} <i class="fa fa-window-close"></i>
                    </div>
				@endif

                <form action="{{ url('verifyRenewal')}}" method="POST">
                    @csrf
                    <div class="form-group">
                        <label>Enter Policy Number or Vehicle Registration Number</label>
                        <input type="text" name="renewal_ID" placeholder="Enter Policy No. or Vehicle Reg. No." class="form-control" />
                    </div>
                    <div class="form-group">
                        <input type="submit" class="btn btn-success bx-pull-right"  style="width:100%" />
                    </div>
                </form>

                @if (Session::has('verifySuccess'))
				  	<div class="alert alert-success text-center" role="alert">
							{{Session::get('verifySuccess')}} <i class="fa fa-check"></i>
					</div>
                    <br/>

                    <table class="table-bordered table-striped table">

                        <tr>
                            <td>Insured Name</td>
                            <td>{{ Session::get('firstName') }} {{ Session::get('lastName') }} </td>
                        </tr>
                        <tr>
                            <td>Policy Purchased</td>
                            <td>{{ Session::get('policy_name') }}</td>
                        </tr>
                        <tr>
                            <td>Policy Number</td>
                            <td>{{ Session::get('policy_number') }}</td>
                        </tr>
                        <tr>
                            <td>Premium Paid</td>
                            <td>{{ Session::get('premium') }}</td>
                        </tr>
                        <tr>
                            <td>Expiry Date</td>
                            <td>{{ Session::get('expiry') }}</td>
                        <tr>

                            </form>
                            <td colspan="2"><a href="{{ url('confirmRenewal') }}" class="btn btn-success bx-pull-right">Proceed to checkout</a></td>
                        </tr>

                    </table>
                @endif

            </div>

        </div>
      </div>
    </section><!-- End Pricing Section -->
</main><!-- End #main -->

  @include('layouts.footer')
@endsection
