@extends('template')
<title>Veritas Kapital Assurance PLC - Account/Login</title>
@section('content')
    @include('layouts.header')

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li>Account</li>
                        <li>Registration</li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->

        <!-- ======= Pricing Section ======= -->
        <section id="pricing" class="pricing inner-page">
            <div id="account-register" class="container">
                <div class="row">
                    <div id="content" class="col-sm-9">
                        <h1>Register Account</h1>
                        <p>If you already have an account with us, please login at the <a href="{{ url('login') }}">login
                                page</a>.</p>
                        @if (Session::has('RegistrationError'))
                            <div class="alert alert-danger" role="alert">
                                <i class="fa fa-window-close"></i>   {{ Session::get('RegistrationError') }}
                            </div>
                        @endif
                        <form action="{{ url('/submitRegister') }}" method="post">
                            @csrf
                            <fieldset id="account">
                                <legend>Your Personal Details</legend>
                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-firstname">First Name</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="firstname" value="{{ old('firstname') }}"
                                            placeholder="First Name" id="input-firstname" class="form-control" />
                                    </div>
                                </div>
                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-lastname">Last Name</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="lastname" value="{{ old('lastname') }}" required
                                            placeholder="Last Name" id="input-lastname" class="form-control" />
                                    </div>
                                </div>
                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-email">E-Mail Address</label>
                                    <div class="col-sm-10">
                                        <input type="email" name="email" value="{{ old('email') }}"
                                            placeholder="E-Mail Address" id="input-email" required class="form-control" />
                                        <span class="text-danger">
                                            @error('email')
                                                {{ $message }}
                                            @enderror
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-telephone">Telephone</label>
                                    <div class="col-sm-10">
                                        <input type="tel" name="phone" value="{{ old('phone') }}" placeholder="Telephone"
                                            id="input-telephone" class="form-control" />
                                    </div>
                                </div>
                                <!--<div class="form-group required">-->
                                <!--    <label class="col-sm-2 control-label" for="input-vka">VKA Number</label>-->
                                <!--    <div class="col-sm-10">-->
                                <!--        <input type="text" name="vka_id" value="{{ old('vka_id') }}"-->
                                <!--            placeholder="Enter full VKA ID (For VKA staff only)" id="input-vka_id" class="form-control" />-->
                                <!--    </div>-->
                                <!--</div>-->
                            </fieldset>
                            <fieldset>
                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-password">Password</label>
                                    <div class="col-sm-10">
                                        <input type="password" name="password" value="" required placeholder="Password"
                                            id="input-password" class="form-control" />
                                        <span class="text-danger">
                                            @error('password')
                                                {{ $message }}
                                            @enderror
                                        </span>
                                    </div>
                                </div>
                            </fieldset>
                            <!--<fieldset>-->
                            <!--    <div class="form-group">-->
                            <!--        <label class="col-sm-4 control-label">Subscribe to our newsletter?</label>-->
                            <!--        <div class="col-sm-10"> <label class="radio-inline">-->
                            <!--                <input type="radio" name="newsletter" value="1" />-->
                            <!--                Yes</label>-->
                            <!--            <label class="radio-inline">-->
                            <!--                <input type="radio" name="newsletter" value="0" checked="checked" />-->
                            <!--                No</label>-->
                            <!--        </div>-->
                            <!--    </div>-->
                            <!--</fieldset>-->

                            <div class="buttons">
                                <div class="pull-right">I have read and agree to the <a
                                        href="https://retail.veritaskapital.com/index.php?route=information/information/agree&amp;information_id=3"
                                        required><b>Privacy Policy</b></a>
                                    <input type="checkbox" name="agree" value="1" required />
                                    &nbsp;
                                    <input type="submit" value="Register" class="btn btn-primary" />
                                </div>
                            </div>
                        </form>
        </section><!-- End Pricing Section -->
    </main><!-- End #main -->

    @include('layouts.footer')
@endsection
