@extends('template')
<title>Veritas Kapital Assurance PLC - Motor</title>
@section('content')
    @include('layouts.header')

    <main id="main">

        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">

                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
                        <li>Motor Insurance</li>
                    </ol>
                </div>

            </div>
        </section><!-- End Breadcrumbs Section -->

        <!-- ======= Pricing Section ======= -->
        <section id="pricing" class="pricing inner-page">
            <div class="container" data-aos="fade-up">

                <div class="category-title">
                    <h1>Motor Insurance​</h1>
                    <!--p>Magnam dolores commodi suscipit. Necessitatibus eius consequatur ex aliquid fuga eum quidem. Sit sint consectetur velit. Quisquam quos quisquam cupiditate. Et nemo qui impedit suscipit alias ea. Quia fugiat sit in iste officiis commodi quidem hic quas.</p-->
                </div>

                <div class="row">
                    @if ( (Session::has('teamId') && $accessStatus === 1) || (Session::has('user_id') && $accessStatus === 0) )
                        @foreach ($mPolicy as $policyData)
                            <div class="col-lg-4 pro-sec" data-aos="fade-up" data-aos-delay="100">
                                <div class="box">
                                    <div class="ins-det">
                                        <img src="{{ asset($policyData->subPolicy_img) }}"><br /><br />
                                        <h4><a href="bookPolicy/{{ $policyData->upc }}" style="font-size:20px;">
                                                {{ $policyData->subPolicy_name }} </a></h4>
                                        <!--span>A simple start for everyone</span-->
                                        <h2>₦ {{ number_format($policyData->subPolicy_price) }}</h2>
                                        <!--p class="total-sum">Total sum insured: ₦ 1,000,000</p-->
                                    </div>
                                    <a href="bookPolicy/{{ $policyData->upc }}" class="vk-btn light">Buy Policy</a>
                                </div>
                            </div>
                        @endforeach
                    @elseif (Session::has('teamId') && $accessStatus === 0)
                        <div class=" col-md-8 offset-2 alert alert-danger text-center" role="alert">
                            <i class="fa fa-window-close"></i> You do not have permission to purchase this policy!
                        </div>
                    @else
                        @foreach ($mPolicy as $policyData)
                            <div class="col-lg-4 pro-sec" data-aos="fade-up" data-aos-delay="100">
                                <div class="box">
                                    <div class="ins-det">
                                        <img src="{{ asset($policyData->subPolicy_img) }}"><br /><br />
                                        <h4><a href="bookPolicy/{{ $policyData->upc }}" style="font-size:20px;">
                                                {{ $policyData->subPolicy_name }} </a></h4>
                                        <!--span>A simple start for everyone</span-->
                                        <h2>₦ {{ number_format($policyData->subPolicy_price) }}</h2>
                                        <!--p class="total-sum">Total sum insured: ₦ 1,000,000</p-->
                                    </div>
                                    <a href="bookPolicy/{{ $policyData->upc }}" class="vk-btn light">Buy Policy</a>
                                </div>
                            </div>
                        @endforeach
                    @endif
                    <!--div class="col-lg-4 pro-sec" data-aos="fade-up" data-aos-delay="100">
                <div class="box">
        <div class="ins-det">
         <img src="{{ asset('assets/img/icons/icon-commercial.png') }}">
         <h4>Commercial</h4>
         <!--span>A simple start for everyone</span>
         <h2>₦ 7,500</h2>
         <!--p class="total-sum">Total sum insured: ₦ 2,000,000</p>
        </div>
         <a href="motor-commercial" class="vk-btn light">Buy Policy</a>
                </div>
              </div->

              <div class="col-lg-4 pro-sec" data-aos="fade-up" data-aos-delay="100">
                <div class="box">
        <div class="ins-det">
         <img src="{{ asset('assets/img/icons/icon-truck.png') }}">
         <h4>Truck</h4>
         <!--span>A simple start for everyone</span>
         <h2>₦ 10,000</h2>
         <!--p class="total-sum">Total sum insured: ₦ 3,000,000</p>
        </div>
         <a href="Motortruck" class="vk-btn light">Buy Policy</a>
                </div>
              </div>
      <div class="col-lg-4 pro-sec" data-aos="fade-up" data-aos-delay="100">
                <div class="box">
        <div class="ins-det">
         <img src="{{ asset('assets/img/icons/icon-motorcycle.png') }}">
         <h4>Tricycle (Motor Cycle)</h4>
         <!--span>A simple start for everyone</span>
         <h2>₦ 2,500</h2>
         <!--p class="total-sum">Total sum insured: ₦ 1,000,000</p>
        </div>
         <a href="Motor-tricycle" class="vk-btn light">Buy Policy</a>
                </div>
              </div>

              <div class="col-lg-4 pro-sec" data-aos="fade-up" data-aos-delay="100">
                <div class="box">
        <div class="ins-det">
         <img src="{{ asset('assets/img/icons/icon-fueltruck.png') }}">
         <h4>Fuel tanker</h4>
         <!--span>A simple start for everyone</span>
         <h2>₦ 25,000</h2>
         <!--p class="total-sum">Total sum insured: ₦ 2,000,000</p>
        </div>
         <a href="Motor-Fueltanker" class="vk-btn light">Buy Policy</a>
                </div>
              </div>

              <div class="col-lg-4 pro-sec" data-aos="fade-up" data-aos-delay="100">
                <div class="box">
        <div class="ins-det">
         <img src="{{ asset('assets/img/icons/icon-firetruck.png') }}">
         <h4>Fire Service truck</h4>
         <!--span>A simple start for everyone</span>
         <h2>₦ 25,000</h2>
         <!--p class="total-sum">Total sum insured: ₦ 3,000,000</p>
        </div>
         <a href="Motor-fireservicetruck" class="vk-btn light">Buy Policy</a>
                </div>
              </div-->

                </div>

            </div>
        </section><!-- End Pricing Section -->
    </main><!-- End #main -->

    @include('layouts.footer')
@endsection
