@extends('template')
<title>Veritas Kapital Assurance PLC - Manage Wallet</title>
@section('content')
    @include('layouts.header')

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
                        <li><a href="{{ url('customerdash') }}">My Dashboard</a> </li>
                        <li><a href="{{ url('customerdash') }}">Wallet</a> </li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->
        <div id="account-account" class="container dashboard">
            <div class="row">
                <div id="content" class="col-md-9 col-sm-8" style="margin-top:50px;">
                    <div class="dashboard--main">
                        <div class="dashboard--top">
                            <div class="row">
                                <div class="col-12">
                                    <h2>Wallet Transactions</h2><br /><br />
                                    <div class="table-responsive" style="overflow-x: auto">
                                        <div class="row">
                                            <div class="col-md-8">
                                                    <a data-toggle="modal" data-target="#exampleModal2"
                                                class="btn btn-submit text-white">Fund Wallet
                                            </a>
                                            </div>
                                            <div class="col-md-4">
                                                <h2 class="pull-right">Balance:
                                                    @if ($getWallet)
                                                        <b>&#8358;{{ number_format($getWallet->Balance) }}</b></h2>
                                                    @else
                                                        <b>&#8358;{{ number_format(0) }}</b></h2>
                                                    @endif

                                            </div>
                                            
                                        </div>
                                        <br/>
                                        <table class="table table-bordered table-striped table-hover" id="example">
                                            <thead>
                                                <th>Transaction Ref</th>
                                                <th>Amount</th>
                                                <th>Transaction Type</th>
                                                <th>Description</th>
                                                <th>Date</th>
                                            </thead>
                                            <tbody>
                                                @foreach ($getWalletDetails as $data1)
                                                    <tr>
                                                        <td>{{ $data1->transaction_reference }}</td>
                                                        <td>{{ number_format($data1->amount) }}</td>
                                                        <td>{{ $data1->transaction_type }}</td>
                                                        <td>{{ $data1->transaction_description }}</td>
                                                        <td>{{ date('Y-m-d', strtotime($data1->Timestamp)) }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <aside class="col-md-3 col-sm-4 col-xs-12 content-aside right_column sidebar-offcanvas">

                    @include('layouts.adminnav')

                </aside>

            </div>


    </main><!-- End #main -->
    <div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Fund Wallet</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="frmUpdateToken" name="frmUpdateToken" method="post" action="javascript:void(0)">
                        <div class="row">
                            <div class="col-md-8 offset-2">
                                <div class="rlr-authforms__inputgroup">
                                    <input type="text" id="total_amount_value" name="total_amount_value"
                                        class="form-control form-control--light" value=""
                                        placeholder="Enter the amount to fund" />
                                    <input type="hidden" name="userId" id="userId" value="{{ session('user_id') }}">
                                    <input type="hidden" name="user_email" id="user_email"
                                        value="{{ $customerData['0']->email }}">
                                </div>
                            </div>
                        </div>
                        <br />
                        <div class="row">
                            <button type="button" onclick="payWithPaystack()" name="pay_now" id="pay_now"
                                class=" col-md-6 offset-3 btn btn-primary btnUpdateToken text-center">Fund
                            </button>
                            <br />
                            <p class=" col-md-12 text-danger text-center">
                                <b>NB: Service Charge of &#8358;100 will be deducted for every wallet funding</b>
                            </p>
                            {{-- <button type="button" class="btn btn-danger pull-right" data-dismiss="modal">Close</button> --}}
                        </div>

                    </form>
                </div>
                <div class="modal-footer">

                </div>
            </div>
        </div>
    </div>

    @include('layouts.footer')
    <Script>
        function formatErrorMessage(jqXHR, exception) {

            if (jqXHR.status === 0) {
                return ('Not connected.\nPlease verify your network connection.');
            } else if (jqXHR.status == 404) {
                return ('The requested page not found. [404]');
            } else if (jqXHR.status == 500) {
                return ('Internal Server Error [500].');
            } else if (exception === 'parsererror') {
                return ('Requested JSON parse failed.');
            } else if (exception === 'timeout') {
                return ('Time out error.');
            } else if (exception === 'abort') {
                return ('Ajax request aborted.');
            } else {
                return ('Uncaught Error.\n' + jqXHR.responseText);
            }
        }

        function payWithPaystack() {

            $(this).hide();
            var amount = document.getElementById('total_amount_value').value;
            var amountValue = amount * 100;
            //print(amount)
            //console.log(amount);
            var handler = PaystackPop.setup({
                key: 'pk_live_2851a8511f7f582cf7e0a99ea96e89b974e48979',
                //key: 'pk_test_110577d52d444541043c731d463ee7411be83f13',
                email: document.getElementById('user_email').value.trim(),
                amount: amountValue,
                currency: 'NGN',
                callback: function(response) {
                    //this happens after the payment is completed successfully
                    var reference = response.reference;
                    iziToast.success({
                        title: 'Please wait...',
                        message: 'Confirming Payment',
                        position: 'topRight'
                    });
                    //alert('Payment complete! Reference: ' + reference);
                    // Make an AJAX call to your server with the reference to verify the transaction
                    $.ajax({
                        url: '/verify_wallet_transaction/' + response.reference +
                            '/customer/{{ $customerData['0']->customer_id }}',
                        method: 'post',
                        data: {
                            "_token": "{{ csrf_token() }}"
                        },
                        dataType: "JSON",
                        success: function(response) {
                            // the transaction status is in response.data.status
                            iziToast.destroy();
                            if (response.status.trim() == "success") {
                                iziToast.success({
                                    title: 'Hurraayy!',
                                    message: response.message,
                                    position: 'topRight'
                                });
                                location.reload();
                            } else {
                                iziToast.error({
                                    title: 'Error',
                                    message: '' + response.message,
                                    position: 'topRight'
                                });
                                $(this).show();
                            }
                        },
                        error: function(x, e) {
                            iziToast.destroy();
                            iziToast.error({
                                title: 'Error',
                                message: '' + formatErrorMessage(x, e),
                                position: 'topRight'
                            });
                            $(this).show();
                        }
                    });
                },
                onClose: function() {
                    alert('Transaction was not completed, window closed.');
                    $(this).show();
                },
            });

            handler.openIframe();

        }
        $(document).ready(function() {
            var table = $('#example').DataTable({
                lengthChange: false,
                buttons: ['copy', 'excel', 'pdf', 'colvis']
            });

            table.buttons().container()
                .appendTo('#example_wrapper .col-md-6:eq(0)');
        });
    </Script>
@endsection
