@extends('template')
<title>Veritas Kapital Assurance PLC - Personal Accident Insurance</title>
@section('content')
    @include('layouts.header')

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
                        <li><a href="{{ url('customerdash') }}">My Dashboard</a> </li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->
        <div id="account-account" class="container dashboard">
            <div class="row">
                <div id="content" class="col-md-9 col-sm-8" style="margin-top:50px;">
                    <div class="dashboard--main">
                        <div class="dashboard--top">
                            <div class="row">
                                <div class="col-12">
                                    <h2>Order History</h2><br />
                                    <div class="table-responsive" style="overflow-x: auto">
                                        <table class="table table-bordered table-striped table-hover">
                                        <thead>
                                            <th>Order ID</th>
                                            <th>Customer</th>
                                            <th>Status</th>
                                            <th>Total</th>
                                            <th>Date Added</th>
                                            <th>Action</th>
                                        </thead>
                                        <tbody>
                                            @foreach ($orderData as $data1)
                                                @if ($data1->order_id == 0)
                                                    <tr>
                                                        <td> No Orders Has Been Made</td>
                                                    </tr>
                                                @else
                                                    <tr>
                                                        <td>#{{ $data1->order_id }}</td>
                                                        <td>{{ $data1->firstName }} {{ $data1->lastName }}</td>
                                                        <td>{{ $data1->order_status_name }}</td>
                                                        <td>{{ $data1->subPolicy_price }}</td>
                                                        <td>{{ $data1->date_added }}</td>
                                                        <td><a href="order_detail/{{ $data1->order_id }}"
                                                                class="vk-btn light"><i class="fa fa-eye"></i></a></td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        </tbody>
                                    </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <aside class="col-md-3 col-sm-4 col-xs-12 content-aside right_column sidebar-offcanvas">

                    @include('layouts.adminnav')

                </aside>

            </div>


    </main><!-- End #main -->

    @include('layouts.footer')
@endsection
