@extends('template')
<title>Veritas Kapital Assurance PLC - Personal Accident Insurance</title>
@section('content')
@include('layouts.header')

<main id="main">
    <!-- ======= Breadcrumbs Section ======= -->
    <section class="breadcrumbs">
      <div class="container">
        <div class="d-flex justify-content-between align-items-center">
          <ol>
          <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li><li><a href="{{ url('customerdash') }}">My Dashboard</a> </li>
          </ol>
        </div>
      </div>
    </section><!-- End Breadcrumbs Section -->
    <div id="account-account" class="container dashboard">
        <div class="row">
            <div id="content" class="col-md-12 col-sm-8" style="margin-top:20px;">
                <div class="dashboard--main">
                    <div class="dashboard--top">
                        <div class="row">
                              <h2>Order Details</h2><br/> 
                              <table class="table table-bordered table-striped">
                                @foreach ($orderData as $data1)
                                    <tr>
                                        <th colspan="2">Order Details</th>
                                    </tr>
                                    <tr>
                                        <th>Order ID</th>
                                        <td>#{{ $data1->order_id }}</td>
                                    </tr>
                                    <tr>
                                        <th>Date Added</th>
                                        <td>{{ $data1->date_added }}</td>
                                    </tr>
                                    <tr>
                                        <th>Customer Name</th>
                                        <td>{{ $data1->firstName }} {{ $data1->lastName }}</td>
                                    </tr>
                                    <tr>
                                        <th>Policy</th>
                                        <td>{{ $data1->subPolicy_name }}</td>
                                    </tr>
                                    <tr>
                                        <th>Product</th>
                                        <td>{{ $data1->policy_name }}</td>
                                    </tr>
                                    @if ($data1->policyID==3)
                                    <tr>
                                        <th>Vehicle Make</th>
                                        <td>{{ $data1->vehicle_make }}</td>
                                    </tr>
                                    <tr>
                                        <th>Vehicle Model</th>
                                        <td>{{ $data1->vehicle_model }}</td>
                                    </tr>
                                    @endif
                                    <tr>
                                        <th>Price</th>
                                        <td>{{ $data1->subPolicy_price }}</td>
                                    </tr>
                                    <tr>
                                        <th>Status</th>
                                        <td>{{ $data1->order_status_name }}</td>
                                    </tr>
                                    <tr>
                                        <th>Billing Address</th>
                                        <td>{{ $data1->address }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                               </table>
                               <a  href="{{ url('orders') }}"   class="vk-btn light"><i class="fa fa-arrow-circle-left"></i> Back</a>
                               <br/>
                        </div>
                    </div>
                </div>
            </div>

    </div>


  </main><!-- End #main -->

  @include('layouts.footer')
@endsection