@extends('template')
<title>Veritas Kapital Assurance PLC - Generate Schedule</title>
@section('content')
    @include('layouts.header')

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
                        <li><a href="{{ url('customerdash') }}">My Dashboard</a> </li>
                        <li><a href="{{ url('customerdash') }}">Generate Schedule</a> </li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->
        <div id="account-account" class="container dashboard">
            <div class="row">
                <div id="content" class="col-md-9 col-sm-8" style="margin-top:50px;">
                    <div class="dashboard--main">
                        <div class="dashboard--top">
                            <div class="row" >
                                <div class="col-12">
                                    <h2>Generate Schedule</h2><br /><br/>
                                    <div class="table-responsive" style="overflow-x: auto">
                                        <table class="table table-bordered table-striped table-hover" id="example">
                                        <thead>
                                            <th>Transaction Ref</th>
                                            <th>Policy Purchased</th>
                                            <th>Transaction Date</th>
                                            <td>Agent Name</td>
                                            <th>Amount</th>
                                        </thead>
                                        <tbody>
                                            @foreach ($getTransaction as $data1)
                                                @if ($data1->order_id == 0)
                                                    <tr>
                                                        <td> No Transactions Has Been Made</td>
                                                    </tr>
                                                @else
                                                    <tr>
                                                        <td>#{{ $data1->transaction_ref }}</td>
                                                        <td>{{ $data1->policy_name }} ({{ $data1->subPolicy_name }})</td>
                                                        <td>{{ date('Y-m-d', strtotime($data1->transaction_date)) }}</td>
                                                         <td>{{ $data1->firstname }} {{ $data1->lastname }}</td>
                                                        <td>{{ $data1->amount }}</td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        </tbody>
                                    </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <aside class="col-md-3 col-sm-4 col-xs-12 content-aside right_column sidebar-offcanvas">

                    @include('layouts.adminnav')

                </aside>

            </div>


    </main><!-- End #main -->

    @include('layouts.footer')
    <Script>
        $(document).ready(function () {
            var table = $('#example').DataTable( {
                    lengthChange: false,
                    buttons: [ 'copy', 'excel', 'pdf', 'colvis' ]
                });

                table.buttons().container()
                    .appendTo( '#example_wrapper .col-md-6:eq(0)' );
                });
    </Script>
@endsection
