@extends('template')
<title>Veritas Kapital Assurance PLC - Personal Accident Insurance</title>
@section('content')
    @include('layouts.header')

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
                        <li><a href="{{ url('customerdash') }}">My Dashboard</a> </li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->
        <div id="account-account" class="container dashboard">
            <div class="row">
                <div id="content" class="col-md-9 col-sm-8" style="margin-top:50px;">
                    <div class="dashboard--main">
                        <div class="dashboard--top">
                            @if (Session::has('success'))
                                <div class="alert alert-success" role="alert">
                                    <i class="fa fa-check"></i> {{ Session::get('success') }}
                                </div>
                            @endif
                            <div class="row">
                                <div id="content" class="col-sm-9">
                                    <h2 style="font-size:15px; font-weight:15px;">My Account Information</h2><br />
                                    @foreach ($customerData as $data)
                                        <form action="{{ url('/personaldetailsUpload') }}" method="post">
                                            @csrf
                                            <input type="hidden" name="userID" value="{{ $data->customer_id }}" />
                                            <input type="hidden" name="newsletter" value="{{ $data->newsletter }}" />
                                            <fieldset>
                                                <legend>Your Personal Details</legend>
                                                <div class="form-group required">
                                                    <label class="col-sm-4 control-label" for="input-firstname">First
                                                        Name</label>
                                                    <div class="col-sm-10">
                                                        <input type="text" name="firstname" value="{{ $data->firstname }}"
                                                            placeholder="First Name" id="input-firstname"
                                                            class="form-control" />
                                                    </div>
                                                </div>
                                                <div class="form-group required">
                                                    <label class="col-sm-4 control-label" for="input-lastname">Last
                                                        Name</label>
                                                    <div class="col-sm-10">
                                                        <input type="text" name="lastname" value="{{ $data->lastname }}"
                                                            required placeholder="Last Name" id="input-lastname"
                                                            class="form-control" />
                                                    </div>
                                                </div>
                                                <div class="form-group required">
                                                    <label class="col-sm-4 control-label" for="input-email">E-Mail
                                                        Address</label>
                                                    <div class="col-sm-10">
                                                        <input type="email" name="email" value="{{ $data->email }}"
                                                            placeholder="E-Mail Address" id="input-email" required
                                                            class="form-control" />
                                                        <span class="text-danger">
                                                            @error('email')
                                                                {{ $message }}
                                                            @enderror
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="form-group required">
                                                    <label class="col-sm-4 control-label"
                                                        for="input-telephone">Telephone</label>
                                                    <div class="col-sm-10">
                                                        <input type="tel" name="phone" value="{{ $data->telephone }}"
                                                            placeholder="Telephone" id="input-telephone"
                                                            class="form-control" />
                                                    </div>
                                                </div>
                                                <input type="submit" value="Update" class="btn btn-primary" />

                                            </fieldset>
                                        </form>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <aside class="col-md-3 col-sm-4 col-xs-12 content-aside right_column sidebar-offcanvas">

                    @include('layouts.adminnav')

                </aside>

            </div>


    </main><!-- End #main -->

    @include('layouts.footer')
@endsection
