@extends('template')
<title>Veritas Kapital Assurance PLC - Personal Accident Insurance</title>
@section('content')
@include('layouts.header')

<main id="main">
    <!-- ======= Breadcrumbs Section ======= -->
    <section class="breadcrumbs">
      <div class="container">
        <div class="d-flex justify-content-between align-items-center">
          <ol>
          <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li><li><a href="{{ url('customerdash') }}">My Dashboard</a> </li>
          </ol>
        </div>
      </div>
    </section><!-- End Breadcrumbs Section -->
    <div id="account-account" class="container dashboard">
        <div class="row">
            <div id="content" class="col-md-9 col-sm-8" style="margin-top:50px;">
                <div class="dashboard--main">
                    <div class="dashboard--top">
                    @if (Session::has('success'))
				  	    <div class="alert alert-success" role="alert">
                            <i class="fa fa-check"></i> {{Session::get('success')}}
					    </div>
                    @elseif (Session::has('error'))
                        <div class="alert alert-danger" role="alert">
                            <i class="fa fa-window-close"></i> {{Session::get('error')}}
					    </div>
				    @endif
                        <div class="row">
                            <div id="content" class="col-sm-9">
                            <h2 style="font-size:15px; font-weight:15px;">Change Password</h2><br/>
                            @foreach ($customerData as $data)
                            <form action="{{ url('updateChangePassword') }}" method="post">
                                            @csrf
                                            <input type="hidden" name="userID" value="{{ $data->customer_id }}" />
                                            <fieldset>
                                                <div class="form-group required">
                                                    <label class="col-sm-4 control-label" for="input-firstname">Old
                                                        Password</label>
                                                    <div class="col-sm-10">
                                                        <input type="password" name="oldpassword" value=""
                                                            placeholder="Enter Old Password" id="input-firstname"
                                                            class="form-control" />
                                                        <span class="text-danger">
                                                            @error('oldpassword')
                                                                {{ $message }}
                                                            @enderror
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="form-group required">
                                                    <label class="col-sm-4 control-label" for="input-firstname">New
                                                        Password</label>
                                                    <div class="col-sm-10">
                                                        <input type="password" name="password" value=""
                                                            placeholder="Enter Password" id="input-firstname"
                                                            class="form-control" />
                                                        <span class="text-danger">
                                                            @error('password')
                                                                {{ $message }}
                                                            @enderror
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="form-group required">
                                                    <label class="col-sm-4 control-label" for="input-lastname">Confirm New
                                                        Password</label>
                                                    <div class="col-sm-10">
                                                        <input type="password" name="confirmPass" value="" required
                                                            placeholder="Enter Password Again" id="input-lastname"
                                                            class="form-control" />
                                                        <span class="text-danger">
                                                            @error('confirmPass')
                                                                {{ $message }}
                                                            @enderror
                                                        </span>
                                                    </div>
                                                </div>
                                                <input type="submit" value="Update" class="btn btn-primary" />

                                            </fieldset>
                                        </form>
                            @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <aside class="col-md-3 col-sm-4 col-xs-12 content-aside right_column sidebar-offcanvas">

                @include('layouts.adminnav')

            </aside>

    </div>


  </main><!-- End #main -->

  @include('layouts.footer')
@endsection
