@extends('template')
<title>Checkout</title>
@section('content')
@include('layouts.header')

<main id="main">
  <!-- ======= Breadcrumbs Section ======= -->
  <section class="breadcrumbs">
    <div class="container">
      <div class="d-flex justify-content-between align-items-center">
        <ol>
          <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li>
          <li>Checkout</li>
        </ol>
      </div>
    </div>
  </section><!-- End Breadcrumbs Section -->

  <!-- ======= Pricing Section ======= -->
  <section id="pricing" class="pricing inner-page">
    <div class="container" data-aos="fade-up">
        <div class="panel panel-default">
          <div class="panel-heading">
            <h4 class="panel-title">Step 2: Confirm Order</h4>
          </div>
          <div class="panel-body">
            <div class="row">
                <div class="col-sm-12">
                    @if (Session::has('msg')) <p class="error text-danger text-bold">{{ Session::get('msg') }}</p> @endif
                    
                    
                    @if(!is_array($orderData))
                        @php $orderData = [$orderData]; @endphp
                    @endif
                    

                    @foreach ($orderData as $data1)
                        
                      @php
                        
                        //if (session()->has('vkaID') && session('userLevel')===10 && $data1->upc ==='010102') {
                        if (session()->has('vkaID') && session('userLevel')===10 && $data1->policyID===3) {
                            $user_commission = ((12.5/100) * $data1->subPolicy_price);//calculate private motor commission
                        //}elseif (session()->has('vkaID') && session('userLevel')===10 && $data1->upc ==='010202') {
                        //    $user_commission = ((12/100) * $data1->subPolicy_price);//calculate commercial motor commission
                        }elseif (session()->has('vkaID') && session('vkaID')!='PHCSale' && session('vkaID')!='KADSale') {
                            $user_commission = ((6.5/100) * $data1->subPolicy_price);
                        }else{
                            $user_commission = 0;
                        }
                      @endphp
                        <div class="table-responsive" style="overflow-x: auto">
                          <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <td>Product Name</td>
                                    <td>Model</td>
                                    <td>Quantity</td>
                                    <td>Unit Price</td>
                                    <td>Total</td>
                                </tr>

                            </thead>
                            <tbody>
                              <tr>
                                <td>{{$data1->subPolicy_name}}</td>
                                <td>{{$data1->policy_name}}</td>
                                <td>1</td>
                                @if ($data1->policyID ===7)
                                    <td>&#8358;{{number_format($premium)}}</td>
                                    <td>&#8358;{{number_format($premium)}}</td>
                                @else
                                    <td>&#8358;{{$data1->subPolicy_price}}</td>
                                    <td>&#8358;{{$data1->subPolicy_price}}</td>
                                @endif
                              </tr>
                              @if (session()->has('vkaID') || session('userLevel')===10)
                              <tr>
                                <td colspan="4">Commission Paid</td>
                                <td>&#8358;{{ $user_commission }}</td>
                              </tr>
                              @endif
                              <tr>
                                @if ($data1->policyID ===7)
                                    <td colspan="4">Sub Total:</td>
                                    <td>&#8358;{{number_format($premium)}}</td>
                                @else
                                    <td colspan="4">Sub Total:</td>
                                    <td>&#8358;{{$data1->subPolicy_price}}</td>
                                @endif

                              </tr>
                              <tr>
                                @if ($data1->policyID ===7)
                                    <td colspan="4">Total:</td>
                                    <td>&#8358;{{number_format($premium)}}</td>
                                @else
                                    <td colspan="4">Total:</td>
                                    <td>&#8358;{{$data1->subPolicy_price}}</td>
                                @endif

                              </tr>
                            </tbody>
                          </table>
                        </div>
                        <form method="post" action="{{ route('pay') }}">
                            @csrf
                            <input type="hidden" name="user_comm" value="{{ $user_commission }}" />
                            <input type="hidden" name="email" value="{{$data1->email}}"> {{-- required --}}
                            <input type="hidden" name="subPolicyId" value="{{$data1->subPolicy_id}}">
                            <input type="hidden" name="orderID" value="{{$data1->order_id}}">
                            <input type="hidden" name="metadata" value="{{ json_encode($array = ['orderID' => $data1->order_id, 'premium' => $data1->subPolicy_price, 'user_comm' => $user_commission, 'policyID' => $data1->policyID, 'subPolicyID' => $data1->subPolicy_id, ]) }}">
                            <input type="hidden" name="callback_url" value="{{ url('payment/callback') }}">
                            <input type="hidden" name="reference" value="{{ $data1->order_id.Paystack::genTranxRef() }}"> {{-- required --}}
                            
                            @if ($data1->policyID ===7)
                                <input type="hidden" name="amount" value="{{$premium *100}}"> {{-- required in kobo --}}
                            @else
                                <input type="hidden" name="amount" value="{{ $data1->subPolicy_price * 100 }}"> {{-- required in kobo --}}
                            @endif
                            

                            <p> <input type="checkbox" name="agree" value="1" required />
                                By confirming this order, I have agreed to the terms and conditions of this company and the payment gateway, as well as keeping track of the transactions I have previously made.</p>
                             {{-- <input type="submit" value="Confirm Order" class="btn btn-primary"> --}}
                             <!--@if ( (session('userLevel')==2 && session('teamId')==2)  || (session('userLevel')==3 && session('teamId')==2) || session('teamId')==9 )-->
                             <!--       <a href="javascript:void(0)" id="btnAutoPayment" rel="{{ $data1->order_id }}" rel2="{{ $data1->subPolicy_price }}" rel3="{{ session()->get('agentPin') }}" class="btn btn-primary">Auto Payment</a>-->
                             <!--@else-->
                             <!--   <input type="submit" value="Confirm Order" class="btn btn-primary">-->
                             <!--@endif-->
                             @if (session('isAutoPay')=="Y" && (session('userLevel')==2 || session('userLevel')==3) && $data1->policyID ===7)
                                <a href="javascript:void(0)" id="btnAutoPayment" rel="{{ $data1->order_id }}" rel2="{{ $premium }}" rel3="{{ session()->get('agentPin') }}" class="btn btn-info">Generate Certificate</a>
                             @elseif(session('isAutoPay')=="Y" && (session('userLevel')==2 || session('userLevel')==3) && $data1->policyID !=7)
                                <a href="javascript:void(0)" id="btnAutoPayment" rel="{{ $data1->order_id }}" rel2="{{ $data1->subPolicy_price }}" rel3="{{ session()->get('agentPin') }}" class="btn btn-info">Generate Certificate</a>
                             @else
                                <input type="submit" value="Pay with Paystack" class="btn btn-primary">
                             @endif
                             
                             @if (session('user_id'))
                                <button type="button" class="btn btn-success  pull-right" data-toggle="modal" data-target="#exampleModal2">
                                    Pay With Wallet Balance
                                </button>
                            @endif
                        </form>
                    @endforeach
                    
                </div>
            </div>
          </div>

        </div>
    </div>
  </section><!-- End Pricing Section -->
</main><!-- End #main -->

<div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Wallet Payment</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="frmDirectWalletPayment" name="frmDirectWalletPayment" method="post" action="javascript:void(0)">
                        <div class="row">
                            <div class="col-md-8 offset-2">
                                <div class="rlr-authforms__inputgroup">
                                    @if (session('user_id'))
                                    <h2 class="text-center">Amount Due:
                                        <b>{{ number_format($data1->policyID == 7 ? $premium : $data1->subPolicy_price) }}</b>
                                    </h2>
                                    <hr><br>
                                    <h2 class="text-center">Wallet
                                        Balance:<b>{{ number_format($getWallet ? $getWallet->Balance : 0) }}</b></h2>
                                    <hr><br>
                                    <input type="hidden" name="amount" id="amount"
                                        value="{{ $data1->policyID == 7 ? $premium : $data1->subPolicy_price }}">
                                    <input type="hidden" name="walletBalance" id="walletBalance"
                                        value="{{ $getWallet ? intval($getWallet->Balance) : 0 }}">
                                    <input type="hidden" name="walletID" id="walletID"
                                        value="{{ $getWallet ? $getWallet->wallet_id : 0 }}">
                                    <input type="hidden" name="userId" id="userId"
                                        value="{{ $getWallet ? $getWallet->customerID : 0 }}">
                                    <input type="hidden" name="orderID" id="orderID" value="{{ $data1->order_id }}">

                                    @endif

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- @if ((session('user_id') && $getWallet && $premium <= $getWallet->Balance) || (session('user_id') && $getWallet && $data1->subPolicy_price <= $getWallet->Balance)) --}}
                           
                            @if(session('user_id') && $getWallet && ($data1->subPolicy_price ?? 0) <= $getWallet->Balance)
                                <button type="button" name="btndirectwalletPayment" id="btndirectwalletPayment"
                                    class=" col-md-6 offset-3 btn btn-primary  text-center">Confirm Payment
                                </button>
                                <br />
                                <p class=" col-md-12 text-danger text-center">
                                    <b>Payment will be processed once confirm payment button is clicked</b>
                                </p>
                            @else
                                <p class=" col-md-12 text-danger text-center">
                                    <b>Insufficient Funds. Please Fund Wallet</b>
                                </p>
                            @endif

                            {{-- <button type="button" class="btn btn-danger pull-right" data-dismiss="modal">Close</button> --}}
                        </div>

                    </form>
                </div>
                <div class="modal-footer">

                </div>
            </div>
        </div>
</div>
    
    
@include('layouts.footer')
<script>
    // Disable right-click on the entire page
document.addEventListener("contextmenu", function (e) {
    e.preventDefault();
});

// Prevent the default action of Ctrl+U
document.addEventListener('keydown', function(event) {
    if (event.ctrlKey && event.key === 'u') {
        event.preventDefault(); 
    }
});
</script>
@endsection
