@extends('template')
<title>Veritas Kapital Assurance PLC - Personal Accident Insurance</title>
@section('content')
@include('layouts.header')

@if (session::has('user_id')){
    return redirect()->route('checkout'); 
@endif
<main id="main">
    <!-- ======= Breadcrumbs Section ======= -->
    <section class="breadcrumbs">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center">
              <ol>
              <li><a href="index"><img src="{{ asset('assets/img/icons/icon-home.png') }}">Home</a></li><li>Checkout</li>
              </ol>
            </div>
          </div>
    </section><!-- End Breadcrumbs Section -->

    <!-- ======= Pricing Section ======= -->
    <section id="pricing" class="pricing inner-page">
      <div class="container" data-aos="fade-up">
                <div class="row">
                    <div class="panel panel-default">
                    <div class="panel-heading">
                    <h4 class="panel-title">Step 1: Checkout Options</h4>
                    </div>
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                      <h2>New Customer</h2>
                                      <p>Checkout Options:</p>
                                        <form method="post" action="{{ ('accountVerify') }}">
                                            @csrf
                                            <!--<div class="radio">
                                                <label><input type="radio" name="account" value="register" checked="checked">Register Account</label>
                                            </div>-->
                                            <div class="radio">
                                                <label><input type="radio" name="account" value="guest">Guest Checkout</label>
                                            </div>
                                                <!--<p>By creating an account you will be able to shop faster, be up to date on an order's status, and keep track of the orders you have previously made.</p>-->
                                            <input type="submit" value="Continue" class="btn btn-primary">
                                        </form>
                                    </div>
                                    <div class="col-sm-6">
                                      <h2>Returning Customer</h2>
                                      <p>I am a returning customer</p>
                                        <form action="{{('checkoutLogin')}}" method="post" >
                                            @csrf
                                            <div class="form-group">
                                                <label class="control-label" for="input-email">E-Mail</label>
                                                <input type="text" name="email" value="" placeholder="E-Mail" id="input-email" class="form-control">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label" for="input-password">Password</label>
                                                <input type="password" name="password" value="" placeholder="Password" id="input-password" class="form-control"><br/>
                                            <input type="submit" value="Login" id="button-login" data-loading-text="Loading..." class="btn btn-primary pull-right">
                                            </div>
                                        </form>
                                    </div>
                            </div>
                    </div>

                </div>
      </div>
    </section><!-- End Pricing Section -->
</main><!-- End #main -->

  @include('layouts.footer')
@endsection