<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Http\Request;

class NiipController extends Controller
{
    public function PopulateVehicleMake()
    {
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://www.niip.ng/api/getMake',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ]);

        $response = curl_exec($curl);

        curl_close($curl);
        //echo $response;
        //json_encode($response);
        $result = json_decode($response);
        //dd($result);

        foreach ($result as $value) {
            $exists = DB::table('tbl_niip_vehicle_make')
                ->where('make', 'like', '%' . $value->name . '%')
                ->first();
            if (!$exists) {
                $insertIntoDB = DB::table('tbl_niip_vehicle_make')->insert([
                    'make' => $value->name,
                    'code' => $value->code,
                ]);
                $msg = 'New records inserted';
            } else {
                $msg = 'No New records to be inserted';
            }
        }
        echo $msg;
    }

    public function PopulateVehicleModel()
    {
        $getMake = DB::table('tbl_niip_vehicle_make')->get();
        //dd($getMake['0']->code);
        foreach ($getMake as $value) {
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL =>
                    'https://www.niip.ng/api/getModel/' . $value->code,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            ]);
            $response = curl_exec($curl);
            curl_close($curl);
            $valResult = json_decode($response);
            //dd($valResult);

            foreach ($valResult as $key) {
                //dd($value);
                $exists = DB::table('tbl_niip_vehicle_model')
                    ->where('model', 'like', '%' . $key->name . '%')
                    ->first();
                if (!$exists && $value->code != 0) {
                    $insertIntoDB = DB::table('tbl_niip_vehicle_model')->insert(
                        [
                            'model' => $key->name,
                            'makeID' => $value->code,
                            'code' => $key->code,
                        ]
                    );
                    $msg = 'New records inserted';
                } else {
                    $msg = 'No New records to be inserted';
                }
            }
        }
        echo $msg;
    }

    public function PopulateVehicleColour()
    {
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://www.niip.ng/api/getColor',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ]);

        $response = curl_exec($curl);

        curl_close($curl);
        //echo $response;
        //json_encode($response);
        $result = json_decode($response);
        //dd($result);

        foreach ($result as $value) {
            $exists = DB::table('tbl_niip_vehicle_colour')
                ->where('colour', 'like', '%' . $value->name . '%')
                ->first();
            if (!$exists) {
                $insertIntoDB = DB::table('tbl_niip_vehicle_colour')->insert([
                    'colour' => $value->name,
                    'code' => $value->code,
                ]);
                $msg = 'New records inserted';
            } else {
                $msg = 'No New records to be inserted';
            }
        }
        echo $msg;
    }

    public function PopulateState()
    {
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://www.niip.ng/api/getState',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ]);

        $response = curl_exec($curl);

        curl_close($curl);
        //echo $response;
        //json_encode($response);
        $result = json_decode($response);
        //dd($result);

        foreach ($result as $value) {
            $exists = DB::table('tbl_niip_state')
                ->where('state', 'like', '%' . $value->name . '%')
                ->first();
            if (!$exists) {
                $insertIntoDB = DB::table('tbl_niip_state')->insert([
                    'state' => $value->name,
                    'code' => $value->code,
                ]);
                $msg = 'New records inserted';
            } else {
                $msg = 'No New records to be inserted';
            }
        }
        echo $msg;
    }

    public function populateLga()
    {
        // Get states from local database
        $states = DB::table('tbl_niip_state')->get();

        // Initialize message variable
        $msg = '';

        // Loop through each state
        foreach ($states as $state) {
            // dd($state->code);
            // Initialize cURL session
            $curl = curl_init();

            // Set cURL options
            curl_setopt_array($curl, [
                CURLOPT_URL =>
                    'https://www.niip.ng/api/getState/' . $state->code,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            ]);

            // Execute cURL request and get response
            $response = curl_exec($curl);

            // Close cURL session
            curl_close($curl);

            // Decode JSON response
            $lgaData = json_decode($response);
            // dd($lgaData);
            // Loop through LGAs of the state
            foreach ($lgaData as $lga) {
                // Check if LGA already exists in the database
                $existingLga = DB::table('tbl_niip_lga')
                    ->where('lga', 'like', '%' . $lga->name . '%')
                    ->first();

                // Insert LGA into the database if it doesn't exist
                if (!$existingLga && $state->code != 0) {
                    DB::table('tbl_niip_lga')->insert([
                        'lga' => $lga->name,
                        'stateID' => $state->code,
                        'code' => $lga->code,
                    ]);
                    $msg = 'New records inserted';
                } else {
                    $msg = 'No new records to be inserted';
                }
            }
        }

        // Output message
        echo $msg;
    }

    public function PopulateEngineCapacity()
    {
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://www.niip.ng/api/getCapacity',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ]);

        $response = curl_exec($curl);

        curl_close($curl);
        //echo $response;
        //json_encode($response);
        $result = json_decode($response);
        //dd($result);

        foreach ($result as $value) {
            $exists = DB::table('tbl_niip_engine_capacity')
                ->where('capacity', 'like', '%' . $value->name . '%')
                ->first();
            if (!$exists) {
                $insertIntoDB = DB::table('tbl_niip_engine_capacity')->insert([
                    'capacity' => $value->name,
                    'code' => $value->code,
                ]);
                $msg = 'New records inserted';
            } else {
                $msg = 'No New records to be inserted';
            }
        }
        echo $msg;
    }

     public function niipUpload($orderID, $policyNo, $eff_date, $naicomID)
    {
        $uploadData = DB::table('tbl_niip_upload')
        ->where('orderID', $orderID)
        ->first();
        //dd($uploadData);

        if ($uploadData) {
            $curl = curl_init();

            $requestData = [
                'APIKey' => 'c0691c69e69541a29a793fc11ed8b31d2f152ec722704c92b2685bec1acd556f',
                'Purpose' => $uploadData->purpose,
                'VehicleColor' => $uploadData->vehicle_colour,
                'VehicleMake' => $uploadData->vehicle_make,
                'VehicleModel' => $uploadData->vehicle_model,
                'EngineCap' => $uploadData->engine_capacity,
                'State' => $uploadData->state,
                'LGA' => $uploadData->lga,
                'RegNo' => $uploadData->reg_no,
                'ChassisNo' => $uploadData->chasis_no,
                'EngineNo' => $uploadData->engine_no,
                'PolicyHolderFirstName' => $uploadData->first_name,
                'PolicyHolderLastName' => $uploadData->last_name,
                'PolicyHolderMobileNo' => $uploadData->phone_number,
                'PolicyHolderEmail' => $uploadData->email_address,
                'IssueDate' => date('Y-m-d'),
                'PolicyHolderAddress' => $uploadData->address,
                'PolicyNumber' => $policyNo,
                'NAICOMUniqueID' => $naicomID,
            ];
            //Carbon::parse($eff_date)->format('Y F d')

            $requestJson = json_encode($requestData);

            curl_setopt_array($curl, [
                CURLOPT_URL => 'https://niip.ng/api/getPolicyByInsuranceCompany',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $requestJson,
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                ],
            ]);

            $response = curl_exec($curl);
            //dd($response);

            if ($response === false) {
                // Handle cURL error
                $errorMsg = curl_error($curl);
                // Log or handle the error accordingly
            }

            curl_close($curl);

            $responseBody = json_decode($response);

            //dd($responseBody);

            if ($responseBody) {
                DB::table('tbl_niip_upload')
                    ->where('upload_id', $uploadData->upload_id)
                    ->update([
                        'is_success' => $responseBody->isSuccess,
                        'message' => $responseBody->message,
                        'brown_card_policy_no' => $responseBody->brownCardPolicyNumber,
                        'policy_number' => $policyNo,
                        'naicomID' => $naicomID,
                        'eff_from_date' => $requestData['IssueDate'],
                    ]);
            } else {
                // Handle invalid response or parsing error
            }

            return true;
        }

        //return false;  No data found for the given orderID
    }


    // public function niipUpload($orderID, $policyNo, $eff_date)
    // {

    //     $get = DB::table('tbl_niip_upload')
    //         ->where('orderID', $orderID)
    //         ->first();

    //     if ($get) {
    //         $curl = curl_init();

    //         curl_setopt_array($curl, [
    //             CURLOPT_URL => 'https://www.niip.ng/api/getPolicyByInsuranceCompany',
    //             CURLOPT_RETURNTRANSFER => true,
    //             CURLOPT_ENCODING => '',
    //             CURLOPT_MAXREDIRS => 10,
    //             CURLOPT_TIMEOUT => 0,
    //             CURLOPT_FOLLOWLOCATION => true,
    //             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    //             CURLOPT_CUSTOMREQUEST => 'POST',
    //             CURLOPT_POSTFIELDS => '{
    //                 "APIKey": "dkfghjfopergjfkrget234u385904r34c4354353454534",
    //                 "Purpose": "'.$get->prupose.'",
    //                 "VehicleColor": "'.$get->vehicle_colour.'",
    //                 "VehicleMake": "'.$get->vehicle_make.'",
    //                 "VehicleModel": "'.$get->vehicle_model.'",
    //                 "EngineCap": "'.$get->engine_capacity.'",
    //                 "State": "'.$get->state.'",
    //                 "LGA": "'.$get->lga.'",
    //                 "RegNo": "'.$get->reg_no.'",
    //                 "ChassisNo": "'.$get->chasis_no.'",
    //                 "EngineNo": "'.$get->engine_no.'",
    //                 "PolicyHolderFirstName": "'.$get->first_name.'",
    //                 "PolicyHolderLastName": "'.$get->last_name.'",
    //                 "PolicyHolderMiddleName": "",
    //                 "PolicyHolderMobileNo": "'.$get->phone_number.'",
    //                 "PolicyHolderEmail": "'.$get->email_address.'",
    //                 "PolicyHolderNIN": "",
    //                 "IssueDate": "'.$get->eff_from_date.'",
    //                 "PolicyHolderAddress": "'.$get->address.'",
    //                 "PolicyNumber": "'.$get->policy_number.'",
    //                 }',
    //             CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
    //         ]);

    //         $response = curl_exec($curl);

    //         curl_close($curl);
    //         // echo $response;
    //         $result = json_decode($response);

    //         $updateResponse = DB::table('tbl_niip_upload')
    //         ->where('id', $get->id)
    //         ->update([
    //             'is_success' => $result->isSuccess,
    //             'message' => $result->message,
    //             'brown_card_policy_no' => $result->brownCardPolicyNumber,
    //             'policy_number' => $policyNo,
    //             'eff_from_date' => $eff_date,
    //         ]);
    //     }

    //     return true;
    // }


}
