<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Event;
use PDF;

class ApiRifanIntegration extends Controller
{
    /*public function thirdPartyCatalog()
    {
        $array = [
            [
                'Label' => 'First Name',
                'Key' => 'FirstName',
                'RegEx' => '[a-zA-Z]',
                'IsRequired' => true,
            ], [
                'Label' => 'Last Name',
                'Key' => 'LastName',
                'RegEx' => '[a-zA-Z]',
                'IsRequired' => true,
            ], [
                'Label' => 'GSM Number',
                'Key' => 'GSMNo',
                'RegEx' => '[0-9]',
                'Example'=>'08031234567',
                'IsRequired' => true,
            ], [
                'Label' => 'Date of Birth',
                'Key' => 'DOB',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,

            ], [
                'Label' => 'Means of Identity Type',
                'Key' => 'MeansOfIdType',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
                'Order' => 1,
                'ReplaceAmount' => false,
                'Options' => ''

            ], [
                'Label' => 'Means Of Identity Number',
                'Key' => 'MeansOfIdNumber',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
                'Order' => 1,
                'ReplaceAmount' => false,
                'Options' => ''

            ], [
                'Label' => 'Sum Insured',
                'Key' => 'sumInsured',
                'RegEx' => '[0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
                'Order' => 1,
                'ReplaceAmount' => false,

            ], [
                'Label' => 'Premium',
                'Key' => 'premium',
                'RegEx' => '[0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
                'Order' => 1,
                'ReplaceAmount' => false,

            ],[
                'Label' => 'effective_date',
                'Key' => 'effective_date',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
                'Order' => 1,
                'ReplaceAmount' => false,

            ],[
                'Label' => 'product_code',
                'Key' => 'product_code',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
                'Order' => 1,
                'ReplaceAmount' => false,

            ],[
                'Label' => 'agency_code',
                'Key' => 'agency_code',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
                'Order' => 1,
                'ReplaceAmount' => false,
                'Response' => 'dev@insuresmart'

            ],
            [
                'Label' => 'Email Address',
                'Key' => 'Email',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
                'Order' => 1,
            ],[
                'Label' => 'Occupation',
                'Key' => 'Occupation of Insured',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
            ],
            [
                'Label' => 'Contact Address',
                'Key' => 'ContactAddress',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
            ], [
                'Label' => 'Vehicle Model',
                'Key' => 'VehicleModel',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
                'Order' => 1,
                'ReplaceAmount' => false,
                'Example' => 'Honda, Toyota, Hyundai, etc',
            ], [
                'Label' => 'Vehicle Make',
                'Key' => 'VehicleMake',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
                'Example' => 'Accord, Camry, Corolla, Elantra, etc',
            ], [
                'Label' => 'Vehicle Type',
                'Key' => 'VehicleType',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
                'Example' => 'Salon, SUV, etc',
            ],
            [
                'Label' => 'Registration Number',
                'Key' => 'RegistrationNumber',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
            ],
            [
                'Label' => 'Transaction ID',
                'Key' => 'Transaction_Id',
                'Description' => 'Payment Gateway Transaction ID',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
            ],
            [
                'Label' => 'Chasis Number',
                'Key' => 'ChasisNumber',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
            ],
            [
                'Label' => 'Vehicle Color',
                'Key' => 'VehicleColor',
                'RegEx' => '[a-zA-Z0-9]',
                'IsRequired' => true,
                'SendToSwitch' => true,
            ]
        ];

        $getProduct = DB::table('tbl_policy')
            ->join('tbl_subpolicy', 'tbl_subpolicy.policyID', '=', 'tbl_policy.policy_id')
            ->where('policyID', '=', 3)
        ->get();

        foreach ($getProduct as  $product) {
            $response[] =  [
                'Name' => $product->subPolicy_name,
                //'ProductDescription' => str_replace("&#40;",'',str_replace("&#41;",'',str_replace("<p>",'',str_replace("</p>",'',str_replace("\r\n",'', $value->prod_desc))))),
                'ProductCode' => $product->upc,
                'Premium' => $product->subPolicy_price,
                'Sum Insured' => $product->sum_insured,
                // //'StandardPrices' => $value->Price.'|'. $this->Product_model->ShortNumberFormat(floatval($value->Price)),
                // 'StandardPrices' => intval($price),
                'Parameters'=>$array,
                'CanChangePrice' => true,
                'Notify' => true,
                'VerifyParameters' => true,
                // 'AmountFromVendor' => false,
                'ParameterLabel' => '',
                'ParameterRegEx' => '',
                'Group' => $product->policy_name,//str_replace("</p>",'',str_replace("</strong>",'',str_replace("<strong>",'',str_replace("<p>",'',str_replace("\r\n",'', $value->name))))),
                //'Order' => 1

            ];
        }



        return response()->json($response);
    }*/

    /*public function generatePolicy(Request $request)
    {
        $rules = [
            'FullName' => 'required|string',
            'GSMNo' => 'required|string|max:11',
            'ContactAddress' => 'required|string|max:255',
            'DOB' => 'required|string|max:255',
            'occupation' => 'required|string|max:255',
            'nationality' => 'required|string|max:255',
            'Gender' => 'required|string|max:255',
            'premium' => 'required|string|max:255',
            'agency_code' => 'required|string|max:255',
            'product_code' => 'required|string|max:255',
            'effective_date' => 'required|string|max:255',
            'VehicleModel' => 'required|string|max:255',
            'VehicleMake' => 'required|string|max:255',
            'VehicleType' => 'required|string|max:255',
            'RegistrationNumber' => 'required|string|max:255',
            'ChasisNumber' => 'required|string|max:255',
            'EngineNumber' => 'required|string|max:255',
            'VehicleColor' => 'required|string|max:255',
            'Email' => 'required|string|max:255',
            'TransactionId' => 'required|string|max:255',
            'transaction_source' => 'required|string|max:255',
        ];
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return response()->json(['status'=>'Error', 'Message' => $validator->errors()], 422);
        }

        //$today = date("Y-m-d");
        $today = date("Y-m-d");


        $getData = DB::connection('api_DB') //authenticate user
            ->table('api_user')
            ->where('company_code', '=', $request->agency_code)
            //->where('company_token', '=', $request->agency_token)
        ->first();

        $getProduct = DB::table('tbl_policy') //check product code
            ->join('tbl_subpolicy', 'tbl_subpolicy.policyID', '=', 'tbl_policy.policy_id')
            ->where('upc', '=', $request->product_code)
        ->first();


        $ifExist = DB::table('tbl_rifan_order') //check product code
            ->join('tbl_rifan_transaction', 'tbl_rifan_transaction.orderID', '=', 'tbl_rifan_order.order_id')
            ->where('car_reg_number', '=', $request->RegistrationNumber)
            //->where('eff_to_date', '=', $request->RegistrationNumber)
            //->limit(1)
        ->first();
        //dd($ifExist);

        if (!$getData) {// check if agency exists
            return response()->json(['status'=>'Error', 'Message' => 'Unauthorized User Entry!'], 423);
        }elseif ($ifExist) { //check if vehicle Plates exists...
            return response()->json(['status'=>'Error', 'Message' => 'Vehicle Plate already exists!'], 421);
        }elseif (!$getProduct) { //check if product code exists
            return response()->json(['status'=>'Error', 'Message' => 'Product does not exist'], 424);
         //}elseif ($getProduct->subPolicy_price != $request->premium) { // check if product code matches with premium
        //     return response()->json(['status'=>'Error', 'Message' => 'Premium does not match selected Product!'], 425);
        }elseif ($request->effective_date < $today) {
            return response()->json(['status'=>'Error', 'Message' => 'Policy effective date must not be more than today!'], 426);
        }else{
            $insertDetails = DB::table('tbl_rifan_order')->insertGetId([
                'engine_number' => $request->EngineNumber,
                'nationality' => $request->Nationality,
                'gender' => $request->Gender,
                'lastName' => $request->FullName,
                'email' => $request->Email,
                'dob' => date('Y-m-d', strtotime($request->DOB)),
                'phone' => $request->GSMNo,
                'vehicle_make' => $request->VehicleMake,
                'vehicle_model' => $request->VehicleModel,
                'form_of_id' => $request->MeansOfIdType,
                'id_number' => $request->MeansOfIdNumber,
                'subPolicyID' => $request->product_code,
                'car_reg_number' => $request->RegistrationNumber,
                'chasis_number' => $request->ChasisNumber,
                'colour' => $request->VehicleColor,
                'address' => $request->ContactAddress,
                'occupation' => $request->Occupation,
                'order_statusID' => 1,
                'sale_channel' => 'API=> '.$request->agency_code,
                'transaction_source' => $request->transaction_source,
                //'api_image_url' => 'API=> '.$request->image_url,
            ]);


            $today_date=date_create($request->effective_date);
            $duration = date_add($today_date,date_interval_create_from_date_string("365 days"));
            $end_date = date_format($duration, "Y-m-d");

            $names = explode(" ", $request->FullName);
            $first_name = $names[0];
            $other_names = implode(" ", array_slice($names, 1));

            $sid_live = 'f409a7ac-1140-4d39-8348-bb72310f60aa';
            $token_live = 'R+b4Xf3W2Eispwn0QBE5TYNIu3IxD2Cq';
            $sid_test = 'd5c6ffef-a99a-405a-9f85-6392f86bffb1';
            $token_test = 'RJFKerqc2Ejv/8bVmqlaQJ+FY5L4a/+x';
            $companyType = 'G';
            $companyId = '74';
            $means_of_id = 'PASSPORT'; //$request['0']->form_of_id ?? $request['0']->form_of_id ?: 'PASSPORT';
            $means_of_id_number = $request->id_number ?? $request->id_number ?: '123456789';
            $insured =$request->FullName;
            $effective_date = date('m/d/Y H:i:s A', strtotime($request->effective_date));
            $expiration_date = date('m/d/Y H:i:s A ', strtotime($end_date));
            $premium = $getProduct->subPolicy_price;
            $product_name = $getProduct->policy_name;
            $product_class = $getProduct->policyID;
            $policyno = 'VKA/' .$getProduct->sku . '/'  .date('Y') .'/' . $getProduct->upc . '/' .'10' . $insertDetails;
            $policy_number = $policyno;
            $sum_insured = $getProduct->sum_insured;
            $registration_number = $request->RegistrationNumber;
            $phone = trim($request->phone) ?? trim($request->phone) ?:'+234(0)700 1000 500';
            $email = trim($request->email) ?? trim($request->email) ?:'info@veritaskapital.com';
            $last_name = $other_names;
            $vehicle_make = $request->VehicleMake;
            $vehicle_model = $request->VehicleModel;
            //if ($getProduct->upc ==="010102") {
                $covertType = "THIRD_PARTY";
            //}
            $niidcovertType = "T";


            $param["sid_live"] = $sid_live;
            $param["token_live"] = $token_live;
            $param["sid_test"] = $sid_test;
            $param["token_test"] = $token_test;
            $param["companyType"] = $companyType;
            $param["companyId"] = $companyId;
            $param["means_of_id"] = $means_of_id;
            $param["means_of_id_number"] = $means_of_id_number;
            $param["phone"] = $phone;
            $param["effective_date"] = $effective_date;
            $param["expiration_date"] = $expiration_date;
            $param["premium"] = $premium;
            $param["product_name"] = $product_name;
            $param["policy_number"] = $policy_number;
            $param["sum_insured"] = $sum_insured;
            $param["registration_number"] = $registration_number;
            $param["email"] = $email;
            $param["insured"] = $insured;
            $param["last_name"] = $last_name;
            $param["vehicle_make"] = $vehicle_make;
            $param["vehicle_model"] = $vehicle_model;
            $param["product_class"] = $product_class;
            $param["covertType"] = $covertType;
            $param["niidcovertType"] = $niidcovertType;
            $param["today_date"] = $today_date;
            $param["end_date"] = $end_date;

           // print_r($param); die();

            $uploadToNaicom = $this->uploadToNaicom($param);
            //dd($uploadToNaicom);
            $uploadToNiid = $this->uploadToNiid($param);
            $certificate_number = 'VKA/CN/100'.$insertDetails;

            $insertTransaction = DB::table('tbl_rifan_transaction')->insertGetId([
                'orderID' => $insertDetails,
                'transaction_ref' => $request->TransactionId,
                'payment_method' => 'N/A',
                'payment_statusID' => 5,
                'amount' => $request->premium,
                'transaction_date' => now(),
                'policy_number'=> $policy_number,
                'certificate_number'=> $certificate_number,
                //'naicom_uid' => $uploadToNaicom['naicomUid'],
                'eff_from_date'=> date('Y-m-d',strtotime($request->effective_date)),
                'eff_to_date'=> $end_date
            ]);
        }


        //if ($uploadToNaicom['status']=="success" && $uploadToNiid) {
        if ($uploadToNiid) {
            $certificateLink = url('/certificate_rifan/'.$registration_number);
            return response()->json([
                'status'=>'Success',
                'message' => 'Policy Generated!',
                'reprintCode'=>$registration_number,
                'registrationNumber'=>$registration_number,
                'commencementDate'=>date('Y-m-d',strtotime($request->effective_date)),
                'expirationDate'=>$end_date,
                'certificateNumber'=>$certificate_number,
                'renewalDate'=>$end_date,
                'policyNumber'=>$policy_number,
                //'naicom_id'=>$uploadToNaicom['naicomUid'],
                'niidResponse'=>'n/a',
                'certificate_link'=> "".stripslashes($certificateLink).""], 201);
        }else {
            return response()->json(['status'=>'error', 'Message' => 'Failed to Generate a policy!']);
        }

    }*/

    /*public function uploadToNaicom($param = array())
    {
        if(count($param) < 1){
            //return error for empty param passed
            return false;
        }

        $sid_live = $param["sid_live"];
        $token_live = $param["token_live"];
        $sid_test = $param["sid_test"];
        $token_test = $param["token_test"];
        $companyType = $param["companyType"];
        $companyId = $param["companyId"];
        $means_of_id = $param["means_of_id"];
        $means_of_id_number = $param["means_of_id_number"];
        $insured = $param["insured"];
        $effective_date = $param["effective_date"];
        $expiration_date = $param["expiration_date"];
        $premium = $param["premium"];
        $product_name = $param["product_name"];
        $policy_number = $param["policy_number"];
        $sum_insured = $param["policy_number"];
        $registration_number = $param["registration_number"];
        $phone = $param["phone"];
        $email = $param["email"];
        $last_name = $param["last_name"];
        $vehicle_make = $param["vehicle_make"];
        $vehicle_model = $param["vehicle_model"];
        $product_class = $param["product_class"];
        $sum_insured = $param["sum_insured"];
        $covertType = $param["covertType"];

        $post_data = [
            "SID" => $sid_live,
            "Token" => $sid_live,
            // 'SID' => $sid_test,
            // 'Token' => $token_test,
            'Type' => 'Auto',
            'DataGroup' => [
                [
                    'GroupName' => 'Basic Info',
                    'GroupTag' => 0,
                    'GroupCount' => 0,
                    'AttArray' => [
                        [
                            'Name' => 'TypeID',
                            'Value' => '127',
                        ],
                        [
                            'Name' => 'CoverageStartDate',
                            'Value' => $effective_date,
                        ],
                        [
                            'Name' => 'CoverageEndDate',
                            'Value' => $expiration_date,
                        ],
                        [
                            'Name' => 'PolicyInternalID',
                            'Value' => $policy_number,
                        ],
                        [
                            'Name' => 'PolicyDescription',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'RecorderType',
                            'Value' => 'Company',
                        ],
                    ],
                ],
                [
                    'GroupName' => 'Detail Info',
                    'GroupTag' => 1,
                    'GroupCount' => 0,
                    'AttArray' => [
                        [
                            'Name' => 'CoverageType',
                            'Value' => $covertType,
                        ],
                        [
                            'Name' => 'OwnerType',
                            'Value' => 'PERSON',
                        ],
                        [
                            'Name' => 'OwnerLicense',
                            'Value' => $registration_number,
                        ],
                        [
                            'Name' => 'PersonNameLast',
                            'Value' => $last_name,
                        ],
                        [
                            'Name' => 'PersonNameFirst',
                            'Value' => $insured,
                        ],
                        [
                            'Name' => 'OrgType',
                            'Value' => 'PRIVATE',
                        ],
                        [
                            'Name' => 'OrgName',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'OrgID',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'AddressLine',
                            'Value' => "address",
                        ],
                        [
                            'Name' => 'CityLGA',
                            'Value' => 'Garki',
                        ],
                        [
                            'Name' => 'State',
                            'Value' => 'Kogi',
                        ],
                        [
                            'Name' => 'PostCode',
                            'Value' => '11755',
                        ],
                        [
                            'Name' => 'Phone',
                            'Value' => $phone,
                        ],
                        [
                            'Name' => 'Email',
                            'Value' => $email,
                        ],
                        [
                            'Name' => 'InsuredValue',
                            'Value' => $sum_insured,
                        ],
                        [
                            'Name' => 'Premium',
                            'Value' => $premium,
                        ],
                        [
                            'Name' => 'CommissionFee',
                            'Value' => '0',
                        ],
                        [
                            'Name' => 'ExtraFee',
                            'Value' => '0',
                        ],
                        [
                            'Name' => 'PremiumNote',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Terms',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Preamble',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Endorsements',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Exclusions',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Exceptions',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Conditions',
                            'Value' => 'n/a',
                        ],
                    ],
                ],
                [
                    'GroupName' => 'Insured Info',
                    'GroupTag' => 2,
                    'GroupCount' => 0,
                    'AttArray' => [
                        [
                            'Name' => 'InsuredNo',
                            'Value' => '1',
                        ],
                        [
                            'Name' => 'VehicleID',
                            'Value' => $registration_number,
                        ],
                        [
                            'Name' => 'PlateNo',
                            'Value' => $registration_number,
                        ],
                        [
                            'Name' => 'RegNo',
                            'Value' => $registration_number,
                        ],
                        [
                            'Name' => 'RegDate',
                            'Value' => 'June 07, 2020', //strtotime('m d, Y')
                        ],
                        [
                            'Name' => 'RegExpDate',
                            'Value' => 'June 07, 2024',
                        ],
                        [
                            'Name' => 'RegMileage',
                            'Value' => '100000',
                        ],
                        [
                            'Name' => 'AutoType',
                            'Value' => 'CAR',
                        ],
                        [
                            'Name' => 'AutoMake',
                            'Value' =>
                                $vehicle_make,
                        ],
                        [
                            'Name' => 'AutoModel',
                            'Value' =>
                                $vehicle_model,
                        ],
                        [
                            'Name' => 'AutoColor',
                            'Value' => 'Custom',
                        ],
                        [
                            'Name' => 'AutoYear',
                            'Value' => '2020',
                        ],
                        [
                            'Name' => 'EngineCap',
                            'Value' => '2.5',
                        ],
                        [
                            'Name' => 'SeatCap',
                            'Value' => '5',
                        ],
                        [
                            'Name' => 'AutoNote',
                            'Value' => 'n/a',
                        ],
                    ],
                ],
            ],
        ];
        //dd($post_data);

        $url_live = 'https://portal.naicom.gov.ng/api/v1/cp/policy/new';
        $url_test = 'https://testportal.naicom.gov.ng:8443/api/v1/cp/policy/new';

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $url_live,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_data),
            CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        ]);

        $response = curl_exec($curl);


        //dd(json_encode($response));

        curl_close($curl);

        $naicom_upload = json_decode($response, true);
       //dd($naicom_upload);

        $uploadToNaicom = DB::table('naicom_upload')->insert([
            'policy_number' => $policy_number,
            //'naicom_uid' => $naicom_upload['PolicyUniqueID'],
            //'naicom_policy_id' => $naicom_upload['PolicyID'],
            'insured_name' => $insured,
            'contact_address' => "address",
            'phone' => $phone,
            'email' => $email,
            'eff_from_date' => date('Y-m-d', strtotime($effective_date)),
            'eff_to_date' => date('Y-m-d', strtotime($expiration_date)),
            'sum_assured' => $sum_insured,
            'premium' => $premium,
            'product_name' => $product_name,
            'date_attempted' => date('Y-m-d H:i:s'),
            'message' => !empty($naicom_upload['ErrMsgs']['0'])
                ? $naicom_upload['ErrMsgs']['0']
                : 'Successful',
            'is_successful' => $naicom_upload['IsSucceed'],
            'create_by' => $email,
        ]);

        if ($naicom_upload['IsSucceed'] == "true" && $uploadToNaicom) {
            return ['status'=>'success', 'naicomUid'=>$naicom_upload['PolicyUniqueID']];
        }else{
            return ['status'=>'error', 'errorMsg'=>"The message"];
        }

    }*/
    
    public function generatePolicy(Request $request)
    {
        $rules = [
            'FullName' => 'required|string',
            'GSMNo' => 'required|string|max:15',
            'ContactAddress' => 'required|string|max:255',
            'DOB' => 'required|string|max:255',
            'occupation' => 'required|string|max:255',
            'nationality' => 'required|string|max:255',
            'Gender' => 'required|string|max:255',
            'premium' => 'required|string|max:255',
            'agency_code' => 'required|string|max:255',
            'product_code' => 'required|string|max:255',
            'effective_date' => 'required|string|max:255',
            'VehicleModel' => 'required|string|max:255',
            'VehicleMake' => 'required|string|max:255',
            'VehicleType' => 'required|string|max:255',
            'RegistrationNumber' => 'required|string|max:255',
            'ChasisNumber' => 'required|string|max:255',
            'EngineNumber' => 'required|string|max:255',
            'VehicleColor' => 'required|string|max:255',
            'Email' => 'required|string|max:255',
            'TransactionId' => 'required|string|max:255',
            'transaction_source' => 'required|string|max:255',
        ];
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return response()->json(['status'=>'Error', 'Message' => $validator->errors()], 422);
        }

        //$today = date("Y-m-d");
        $today = date("Y-m-d");


        $getData = DB::connection('api_DB') //authenticate user
            ->table('api_user')
            ->where('company_code', '=', $request->agency_code)
            //->where('company_token', '=', $request->agency_token)
        ->first();

        $getProduct = DB::table('tbl_policy') //check product code
            ->join('tbl_subpolicy', 'tbl_subpolicy.policyID', '=', 'tbl_policy.policy_id')
            ->where('upc', '=', $request->product_code)
        ->first();
        
        $ifExist = DB::table('tbl_rifan_order') //check product code
            ->join('tbl_rifan_transaction', 'tbl_rifan_transaction.orderID', '=', 'tbl_rifan_order.order_id')
            ->where('car_reg_number', '=', $request->RegistrationNumber)
            //->where('eff_to_date', '=', $request->RegistrationNumber)
            //->limit(1)
        ->first();
        //dd($ifExist);

        if (!$getData) {// check if agency exists
            return response()->json(['status'=>'Error', 'Message' => 'Unauthorized User Entry!'], 423);
        }elseif ($ifExist) { //check if vehicle Plates exists...
            return response()->json(['status'=>'Error', 'Message' => 'Vehicle Plate already exists!'], 421);
        }elseif (!$getProduct) { //check if product code exists
            return response()->json(['status'=>'Error', 'Message' => 'Product does not exist'], 424);
         //}elseif ($getProduct->subPolicy_price != $request->premium) { // check if product code matches with premium
        //     return response()->json(['status'=>'Error', 'Message' => 'Premium does not match selected Product!'], 425);
        }elseif ($request->effective_date < $today) {
            return response()->json(['status'=>'Error', 'Message' => 'Policy effective date must not be more than today!'], 426);
        }else{
            $insertDetails = DB::table('tbl_rifan_order')->insertGetId([
                'engine_number' => $request->EngineNumber,
                'nationality' => $request->Nationality,
                'gender' => $request->Gender,
                'lastName' => $request->FullName,
                'email' => $request->Email,
                'dob' => date('Y-m-d', strtotime($request->DOB)),
                'phone' => $request->GSMNo,
                'vehicle_make' => $request->VehicleMake,
                'vehicle_model' => $request->VehicleModel,
                'form_of_id' => $request->MeansOfIdType,
                'id_number' => $request->MeansOfIdNumber,
                'subPolicyID' => $request->product_code,
                'car_reg_number' => $request->RegistrationNumber,
                'chasis_number' => $request->ChasisNumber,
                'colour' => $request->VehicleColor,
                'address' => $request->ContactAddress,
                'occupation' => $request->Occupation,
                'order_statusID' => 1,
                'sale_channel' => 'API=> '.$request->agency_code,
                'transaction_source' => $request->transaction_source,
                //'api_image_url' => 'API=> '.$request->image_url,
            ]);


            $_date=date_create($request->effective_date);
            $today_date = date_format($_date, "Y-m-d H:i:s");
            $duration = date_add($_date,date_interval_create_from_date_string("365 days"));
            $end_date = date_format($duration, "Y-m-d");

            $names = explode(" ", $request->FullName);
            $first_name = $names[0];
            $other_names = implode(" ", array_slice($names, 1));

            $sid_live = 'f409a7ac-1140-4d39-8348-bb72310f60aa';
            $token_live = 'R+b4Xf3W2Eispwn0QBE5TYNIu3IxD2Cq';
            $sid_test = 'd5c6ffef-a99a-405a-9f85-6392f86bffb1';
            $token_test = 'RJFKerqc2Ejv/8bVmqlaQJ+FY5L4a/+x';
            $companyType = 'G';
            $companyId = '74';
            $means_of_id = 'PASSPORT'; //$request['0']->form_of_id ?? $request['0']->form_of_id ?: 'PASSPORT';
            $means_of_id_number = $request->id_number ?? $request->id_number ?: '123456789';
            $insured =$request->FullName;
            $effective_date = date('m/d/Y H:i:s A', strtotime($request->effective_date));
            $expiration_date = date('m/d/Y H:i:s A ', strtotime($end_date));
            $premium = $getProduct->subPolicy_price;
            $product_name = $getProduct->policy_name;
            $product_class = $getProduct->policyID;
            $policyno = 'VKA/' .$getProduct->sku . '/'  .date('Y') .'/' . $getProduct->upc . '/' .'10' . $insertDetails;
            $policy_number = $policyno;
            $sum_insured = $getProduct->sum_insured;
            $registration_number = $request->RegistrationNumber;
            $phone = trim($request->phone) ?? trim($request->phone) ?:'+234(0)700 1000 500';
            $email = trim($request->email) ?? trim($request->email) ?:'info@veritaskapital.com';
            $last_name = $other_names;
            $vehicle_make = $request->VehicleMake;
            $vehicle_model = $request->VehicleModel;
            //if ($getProduct->policyID ==="3") {
                $covertType = "THIRD_PARTY";
            ///}
            $niidcovertType = "T";


            $param["sid_live"] = $sid_live;
            $param["token_live"] = $token_live;
            $param["sid_test"] = $sid_test;
            $param["token_test"] = $token_test;
            $param["companyType"] = $companyType;
            $param["companyId"] = $companyId;
            $param["means_of_id"] = $means_of_id;
            $param["means_of_id_number"] = $means_of_id_number;
            $param["phone"] = $phone;
            $param["effective_date"] = $effective_date;
            $param["expiration_date"] = $expiration_date;
            $param["premium"] = $premium;
            $param["product_name"] = $product_name;
            $param["policy_number"] = $policy_number;
            $param["sum_insured"] = $sum_insured;
            $param["registration_number"] = $registration_number;
            $param["email"] = $email;
            $param["insured"] = $insured;
            $param["last_name"] = $last_name;
            $param["vehicle_make"] = $vehicle_make;
            $param["vehicle_model"] = $vehicle_model;
            $param["product_class"] = $product_class;
            $param["covertType"] = $covertType;
            $param["niidcovertType"] = $niidcovertType;
            $param["today_date"] = $today_date;
            $param["end_date"] = $end_date;

           // print_r($param); die();

            $uploadToNaicom = $this->uploadToNaicom($param);
            //dd($uploadToNaicom);
            $uploadToNiid = $this->uploadToNiid($param);
            $certificate_number = 'VKA/CN/100'.$insertDetails;

            if ($uploadToNaicom['status']=="success" && $uploadToNiid) { //when Naicom Succeeds

                $insertTransaction = DB::table('tbl_rifan_transaction')->insertGetId([
                    'orderID' => $insertDetails,
                    'transaction_ref' => $request->TransactionId,
                    'payment_method' => 'N/A',
                    'payment_statusID' => 5,
                    'amount' => $request->premium,
                    'transaction_date' => now(),
                    'policy_number'=> $policy_number,
                    'certificate_number'=> $certificate_number,
                    'naicom_uid' => $uploadToNaicom['naicomUid'],
                    'eff_from_date'=> date('Y-m-d',strtotime($request->effective_date)),
                    'eff_to_date'=> $end_date
                ]);

                $certificateLink = url('/certificate_rifan/'.$insertTransaction);
                return response()->json([
                    'status'=>'Success',
                    'message' => 'Policy Generated!',
                    'reprintCode'=>$registration_number,
                    'registrationNumber'=>$registration_number,
                    'commencementDate'=>date('Y-m-d',strtotime($request->effective_date)),
                    'expirationDate'=>$end_date,
                    'certificateNumber'=>$certificate_number,
                    'renewalDate'=>$end_date,
                    'policyNumber'=>$policy_number,
                    'naicom_id'=>$uploadToNaicom['naicomUid'],
                    'niidResponse'=>'n/a',
                    'certificate_link'=> "".stripslashes($certificateLink).""], 201);

            }elseif ($uploadToNaicom['status']!="success" && $uploadToNiid) { //when naicom fails

                $insertTransaction = DB::table('tbl_rifan_transaction')->insertGetId([
                    'orderID' => $insertDetails,
                    'transaction_ref' => $request->TransactionId,
                    'payment_method' => 'N/A',
                    'payment_statusID' => 5,
                    'amount' => $request->premium,
                    'transaction_date' => now(),
                    'policy_number'=> $policy_number,
                    'certificate_number'=> $certificate_number,
                    //'naicom_uid' => $uploadToNaicom['naicomUid'],
                    'eff_from_date'=> date('Y-m-d',strtotime($request->effective_date)),
                    'eff_to_date'=> $end_date
                ]);

                $certificateLink = url('/certificate_rifan/'.$insertTransaction);
                return response()->json([
                    'status'=>'Success',
                    'message' => 'Policy Generated! Naicom Unavailable!',
                    'reprintCode'=>$registration_number,
                    'registrationNumber'=>$registration_number,
                    'commencementDate'=>date('Y-m-d',strtotime($request->effective_date)),
                    'expirationDate'=>$end_date,
                    'certificateNumber'=>$certificate_number,
                    'renewalDate'=>$end_date,
                    'policyNumber'=>$policy_number,
                    'naicom_id'=>'Unavailable',
                    'niidResponse'=>'n/a',
                    'certificate_link'=> "".stripslashes($certificateLink).""], 201);

            }else {
                return response()->json(['status'=>'error', 'Message' => 'Failed to Generate a policy!']);
            }
        }

    }
    
    public function uploadToNaicom($param = array())
    {
        if(count($param) < 1){
            //return error for empty param passed
            return false;
        }

        $sid_live = $param["sid_live"];
        $token_live = $param["token_live"];
        $sid_test = $param["sid_test"];
        $token_test = $param["token_test"];
        $companyType = $param["companyType"];
        $companyId = $param["companyId"];
        $means_of_id = $param["means_of_id"];
        $means_of_id_number = $param["means_of_id_number"];
        $insured = $param["insured"];
        $effective_date = $param["effective_date"];
        $expiration_date = $param["expiration_date"];
        $premium = $param["premium"];
        $product_name = $param["product_name"];
        $policy_number = $param["policy_number"];
        $sum_insured = $param["policy_number"];
        $registration_number = $param["registration_number"];
        $phone = $param["phone"];
        $email = $param["email"];
        $last_name = $param["last_name"];
        $vehicle_make = $param["vehicle_make"];
        $vehicle_model = $param["vehicle_model"];
        $product_class = $param["product_class"];
        $sum_insured = $param["sum_insured"];
        $covertType = $param["covertType"];

        $post_data = [
            "SID" => $sid_live,
            "Token" => $sid_live,
            // 'SID' => $sid_test,
            // 'Token' => $token_test,
            'Type' => 'Auto',
            'DataGroup' => [
                [
                    'GroupName' => 'Basic Info',
                    'GroupTag' => 0,
                    'GroupCount' => 0,
                    'AttArray' => [
                        [
                            'Name' => 'TypeID',
                            'Value' => '127',
                        ],
                        [
                            'Name' => 'CoverageStartDate',
                            'Value' => $effective_date,
                        ],
                        [
                            'Name' => 'CoverageEndDate',
                            'Value' => $expiration_date,
                        ],
                        [
                            'Name' => 'PolicyInternalID',
                            'Value' => $policy_number,
                        ],
                        [
                            'Name' => 'PolicyDescription',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'RecorderType',
                            'Value' => 'Company',
                        ],
                    ],
                ],
                [
                    'GroupName' => 'Detail Info',
                    'GroupTag' => 1,
                    'GroupCount' => 0,
                    'AttArray' => [
                        [
                            'Name' => 'CoverageType',
                            'Value' => $covertType,
                        ],
                        [
                            'Name' => 'OwnerType',
                            'Value' => 'PERSON',
                        ],
                        [
                            'Name' => 'OwnerLicense',
                            'Value' => $registration_number,
                        ],
                        [
                            'Name' => 'PersonNameLast',
                            'Value' => $last_name,
                        ],
                        [
                            'Name' => 'PersonNameFirst',
                            'Value' => $insured,
                        ],
                        [
                            'Name' => 'OrgType',
                            'Value' => 'PRIVATE',
                        ],
                        [
                            'Name' => 'OrgName',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'OrgID',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'AddressLine',
                            'Value' => "address",
                        ],
                        [
                            'Name' => 'CityLGA',
                            'Value' => 'Garki',
                        ],
                        [
                            'Name' => 'State',
                            'Value' => 'Kogi',
                        ],
                        [
                            'Name' => 'PostCode',
                            'Value' => '11755',
                        ],
                        [
                            'Name' => 'Phone',
                            'Value' => $phone,
                        ],
                        [
                            'Name' => 'Email',
                            'Value' => $email,
                        ],
                        [
                            'Name' => 'InsuredValue',
                            'Value' => $sum_insured,
                        ],
                        [
                            'Name' => 'Premium',
                            'Value' => $premium,
                        ],
                        [
                            'Name' => 'CommissionFee',
                            'Value' => '0',
                        ],
                        [
                            'Name' => 'ExtraFee',
                            'Value' => '0',
                        ],
                        [
                            'Name' => 'PremiumNote',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Terms',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Preamble',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Endorsements',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Exclusions',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Exceptions',
                            'Value' => 'n/a',
                        ],
                        [
                            'Name' => 'Conditions',
                            'Value' => 'n/a',
                        ],
                    ],
                ],
                [
                    'GroupName' => 'Insured Info',
                    'GroupTag' => 2,
                    'GroupCount' => 0,
                    'AttArray' => [
                        [
                            'Name' => 'InsuredNo',
                            'Value' => '1',
                        ],
                        [
                            'Name' => 'VehicleID',
                            'Value' => $registration_number,
                        ],
                        [
                            'Name' => 'PlateNo',
                            'Value' => $registration_number,
                        ],
                        [
                            'Name' => 'RegNo',
                            'Value' => $registration_number,
                        ],
                        [
                            'Name' => 'RegDate',
                            'Value' => 'June 07, 2020', //strtotime('m d, Y')
                        ],
                        [
                            'Name' => 'RegExpDate',
                            'Value' => 'June 07, 2024',
                        ],
                        [
                            'Name' => 'RegMileage',
                            'Value' => '100000',
                        ],
                        [
                            'Name' => 'AutoType',
                            'Value' => 'CAR',
                        ],
                        [
                            'Name' => 'AutoMake',
                            'Value' =>
                                $vehicle_make,
                        ],
                        [
                            'Name' => 'AutoModel',
                            'Value' =>
                                $vehicle_model,
                        ],
                        [
                            'Name' => 'AutoColor',
                            'Value' => 'Custom',
                        ],
                        [
                            'Name' => 'AutoYear',
                            'Value' => '2020',
                        ],
                        [
                            'Name' => 'EngineCap',
                            'Value' => '2.5',
                        ],
                        [
                            'Name' => 'SeatCap',
                            'Value' => '5',
                        ],
                        [
                            'Name' => 'AutoNote',
                            'Value' => 'n/a',
                        ],
                    ],
                ],
            ],
        ];
        //dd($post_data);

        $url_live = 'https://portal.naicom.gov.ng/api/v1/cp/policy/new';
        $url_test = 'https://testportal.naicom.gov.ng:8443/api/v1/cp/policy/new';

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $url_live,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_data),
            CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        ]);

        $response = curl_exec($curl);


        //dd(json_encode($response));

        curl_close($curl);

        $naicom_upload = json_decode($response, true);
        //dd($naicom_upload);
        if ($naicom_upload['IsSucceed'] == "true") {

            $uploadToNaicom = DB::table('naicom_upload')->insert([
                'policy_number' => $policy_number,
                'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                'naicom_policy_id' => $naicom_upload['PolicyID'],
                'insured_name' => $insured,
                'contact_address' => "address",
                'phone' => $phone,
                'email' => $email,
                'eff_from_date' => date('Y-m-d', strtotime($effective_date)),
                'eff_to_date' => date('Y-m-d', strtotime($expiration_date)),
                'sum_assured' => $sum_insured,
                'premium' => $premium,
                'product_name' => $product_name,
                'date_attempted' => date('Y-m-d H:i:s'),
                'message' => !empty($naicom_upload['ErrMsgs']['0'])
                    ? $naicom_upload['ErrMsgs']['0']
                    : 'Successful',
                'is_successful' => $naicom_upload['IsSucceed'],
                'create_by' => $email,
            ]);

        return ['status'=>'success', 'naicomUid'=>$naicom_upload['PolicyUniqueID']];

        //if ($naicom_upload['IsSucceed'] == "true" && $uploadToNaicom) {

        }else{
            return ['status'=>'error', 'errorMsg'=>'Error Uploading to NAICOM: '.$naicom_upload['message']];
        }

    }


    public function uploadToNiid($param = array())
    {
        if(count($param) < 1){
            //return error for empty param passed
            return false;
        }

        $covertType = $param["covertType"];
        $niidcovertType = $param["niidcovertType"];
        $insured = $param["insured"];
        $today_date = $param["today_date"];
        $end_date = $param["end_date"];
        $effective_date = $param["effective_date"];
        $expiration_date = $param["expiration_date"];
        $premium = $param["premium"];
        $product_name = $param["product_name"];
        $policy_number = $param["policy_number"];
        $sum_insured = $param["policy_number"];
        $registration_number = $param["registration_number"];
        $phone = $param["phone"];
        $email = $param["email"];
        $vehicle_make = $param["vehicle_make"];
        $vehicle_model = $param["vehicle_model"];
        $sum_insured = $param["sum_insured"];

        $uploadToNiid = DB::table('3rd_niid_web_service_register')
        ->insert([
           'policy_no' => $policy_number,
           'insured_name' => $insured,
           'contact_address' => "address",
           'gsm' => $phone,
           'email' => $email,
           'eff_from_date' => $today_date,
           'eff_to_date' => $end_date,
           'type_of_cover' => $niidcovertType,
           'vehicle_category' => 'TBA',
           'engine_no' => $registration_number,
           'chasis_no' => $registration_number,
           'vehicle_color' => "custom",
           'year_of_make' => 'year_made',
           'vehicle_make' => $vehicle_make,
           'registration_no' => $registration_number,
           'vehicle_type' => $product_name,
           'engine_capacity' => 'TBA',
           'vehicle_model' => $vehicle_model,
           'sum_assured' => $sum_insured,
           'premium' => $premium,
           'cover_note_no' => 'TBA',
           'certificate_no' => 'TBA',
           'geographical_zone' => 'TBA',
           'message' => '',
           'is_successful' => 0,
           'date_attempted' => now(),
        ]);
        if ($uploadToNiid) {
            return ['status'=>'success', 'msg' => 'Upload to NIID Successful!'];
        }else{
            return ['status'=>'error', 'msg' => 'Failed to Upload to NIID!'];
        }

    }
    
    public function generateCertificate($id)
    {
        $transData = DB::table('tbl_rifan_transaction')
            ->join(
                'tbl_rifan_order',
                'tbl_rifan_order.order_id',
                '=',
                'tbl_rifan_transaction.orderID'
            )
            ->join(
                'tbl_api_subpolicy',
                'tbl_api_subpolicy.upc',
                '=',
                'tbl_rifan_order.subPolicyID'
            )
            ->join(
                'tbl_api_policy',
                'tbl_api_policy.policy_id',
                '=',
                'tbl_api_subpolicy.policyID'
            )
            //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
            ->WHERE('tbl_rifan_order.car_reg_number', '=', $id)
            ->WHERE('tbl_rifan_transaction.payment_statusID', '=', 5)
            ->orderBy('transaction_date', 'desc')->limit(1)->get();
            //->get();

        //dd($transData);
        //session()->forget('transID');

        $pdf = PDF::loadView('body.apiCert.rifan_certificate', compact('transData'));
        return $pdf->download('certificate.pdf');

    }
}
